/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.FrameLocPass;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.ExprStmt;
import org.aspectj.compiler.base.ast.ReturnStmt;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class BlockStmt
extends Stmt {
    protected Stmts tmpStmts;
    protected Stmts stmts;

    public boolean isEmpty() {
        int len = this.getStmts().size();
        int i = 0;
        while (i < len) {
            if (!this.getStmts().get(i).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void requireBlockStmt() {
    }

    private static Stmt makeStmt(ASTObject node) {
        if (node instanceof Stmt) {
            return (Stmt)node;
        }
        if (node instanceof Expr) {
            return new ExprStmt(node.getSourceLocation(), (Expr)node);
        }
        throw new RuntimeException("node can not be made into a statement: " + node);
    }

    public BlockStmt(SourceLocation location, ASTObject node1) {
        this(location, node1 instanceof BlockStmt ? ((BlockStmt)node1).getStmts() : new Stmts(location, new Stmt[]{BlockStmt.makeStmt(node1)}));
    }

    public BlockStmt(SourceLocation location, ASTObject node1, ASTObject node2) {
        this(location, new Stmts(location, new Stmt[]{BlockStmt.makeStmt(node1), BlockStmt.makeStmt(node2)}));
    }

    public BlockStmt(SourceLocation location, ASTObject node1, ASTObject node2, ASTObject node3) {
        this(location, new Stmts(location, new Stmt[]{BlockStmt.makeStmt(node1), BlockStmt.makeStmt(node2), BlockStmt.makeStmt(node3)}));
    }

    public BlockStmt(SourceLocation location, ASTObject node1, ASTObject node2, ASTObject node3, ASTObject node4) {
        this(location, new Stmts(location, new Stmt[]{BlockStmt.makeStmt(node1), BlockStmt.makeStmt(node2), BlockStmt.makeStmt(node3), BlockStmt.makeStmt(node4)}));
    }

    public boolean mustBeLive() {
        return !this.getOptions().lenient;
    }

    public void walkFlow(FlowCheckerPass w) {
        Stmts s = this.getStmts();
        int i = 0;
        int len = s.size();
        while (i < len) {
            Stmt st = s.get(i);
            if (!w.isLive() && st.mustBeLive()) {
                st.showError("unreachable statement");
                break;
            }
            w.process(s.get(i));
            ++i;
        }
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
        this.makeTempsExplicit();
        this.getStmts().walkCleanup(w);
    }

    public ASTObject postCleanup(ByteCodeCleanupPass w) {
        if (this.getStmts().size() == 0) {
            return this.getAST().makeEmptyStmt().setSource(this);
        }
        return this;
    }

    protected void makeTempsExplicit() {
        if (this.tmpStmts != null) {
            int i = 0;
            int len = this.tmpStmts.size();
            while (i < len) {
                this.getStmts().add(0, this.tmpStmts.get(i));
                ++i;
            }
            this.tmpStmts = null;
        }
    }

    public void walkFrameLoc(FrameLocPass walker) {
        int start = walker.getfs();
        super.walkFrameLoc(walker);
        walker.setfs(start);
    }

    public void preScope(ScopeWalker walker) {
        walker.pushBlock();
    }

    public ASTObject postScope(ScopeWalker walker) {
        walker.popBlock();
        return this;
    }

    public VarDec makeTemporary(Type type) {
        VarDec tmp = this.getAST().makeVarDec(type, "ajc$tmp", null);
        this.addTemporary(tmp);
        this.tmpStmts.add(0, tmp);
        return tmp;
    }

    public void addTemporary(VarDec tmp) {
        if (this.getTmpStmts() == null) {
            this.setTmpStmts(this.getAST().makeStmts());
        }
        tmp.setId(tmp.getId() + this.tmpStmts.size());
        this.tmpStmts.add(0, tmp);
    }

    public void checkReturnType(Type expectedReturnType) {
        ReturnTypeChecker rtc = new ReturnTypeChecker(this.getCompiler(), expectedReturnType);
        rtc.process(this.stmts);
    }

    public void unparse(CodeWriter writer) {
        writer.openBlock();
        if (this.tmpStmts != null) {
            writer.write(this.tmpStmts);
        }
        writer.write(this.stmts);
        writer.closeBlock();
    }

    public void cleanup() {
        this.stmts = null;
        this.tmpStmts = null;
        super.cleanup();
    }

    protected void cgStmt(CodeBuilder cb) {
        cb.enterBlock();
        this.stmts.cgStmts(cb);
        cb.exitBlock();
    }

    public BlockStmt(SourceLocation location, Stmts _stmts) {
        this(location, null, _stmts);
    }

    public Stmts getTmpStmts() {
        return this.tmpStmts;
    }

    public void setTmpStmts(Stmts _tmpStmts) {
        if (_tmpStmts != null) {
            _tmpStmts.setParent(this);
        }
        this.tmpStmts = _tmpStmts;
    }

    public Stmts getStmts() {
        return this.stmts;
    }

    public void setStmts(Stmts _stmts) {
        if (_stmts != null) {
            _stmts.setParent(this);
        }
        this.stmts = _stmts;
    }

    public BlockStmt(SourceLocation location, Stmts _tmpStmts, Stmts _stmts) {
        super(location);
        this.setTmpStmts(_tmpStmts);
        this.setStmts(_stmts);
    }

    protected BlockStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        BlockStmt ret = new BlockStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.tmpStmts != null) {
            ret.setTmpStmts((Stmts)walker.process(this.tmpStmts));
        }
        if (this.stmts != null) {
            ret.setStmts((Stmts)walker.process(this.stmts));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.tmpStmts;
            }
            case 1: {
                return this.stmts;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "tmpStmts";
            }
            case 1: {
                return "stmts";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTmpStmts((Stmts)child);
                return;
            }
            case 1: {
                this.setStmts((Stmts)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "BlockStmt()";
    }

    static class ReturnTypeChecker
    extends Walker {
        Type expectedReturnType;

        ReturnTypeChecker(JavaCompiler compiler, Type expectedReturnType) {
            super(compiler);
            this.expectedReturnType = expectedReturnType;
        }

        public boolean preProcess(ASTObject node) {
            if (node instanceof ReturnStmt) {
                Expr returnExpr = ((ReturnStmt)node).getExpr();
                if (returnExpr == null) {
                    if (!this.expectedReturnType.isEquivalent(this.getTypeManager().voidType)) {
                        node.showError(this.expectedReturnType.toShortString() + " return expected");
                    }
                } else if (!this.expectedReturnType.isAssignableFrom(returnExpr.getType())) {
                    node.showError(this.expectedReturnType.toShortString() + " return expected");
                }
                return true;
            }
            return !(node instanceof TypeDec);
        }
    }
}

