/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.IntegralType;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.UnopExpr;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class BitNotOpExpr
extends UnopExpr {
    protected LiteralExpr halfFold(Type type, LiteralExpr lit) {
        return type.foldBitNotOp(lit);
    }

    protected Type discoverType() {
        Expr rand1 = this.getRand1();
        Type ty1 = rand1.getType();
        if (ty1 instanceof IntegralType) {
            return this.getTypeManager().unaryNumericPromotion(ty1);
        }
        this.showOperatorTypeError(ty1);
        return this.getTypeManager().anyType;
    }

    protected Type getLiftType() {
        return this.getType();
    }

    protected void cgValue(CodeBuilder cb) {
        Type liftType = this.getLiftType();
        this.getRand1().cgValue(cb, liftType);
        liftType.emitBitNot(cb);
    }

    public BitNotOpExpr(SourceLocation location, String _op, Expr _rand1) {
        super(location, _op, _rand1);
    }

    protected BitNotOpExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        BitNotOpExpr ret = new BitNotOpExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.op = this.op;
        if (this.rand1 != null) {
            ret.setRand1((Expr)walker.process(this.rand1));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "BitNotOpExpr(op: " + this.op + ")";
    }
}

