/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AssignExpr;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class BasicAssignExpr
extends AssignExpr {
    public Type discoverType() {
        Type lhsType = this.lhs.getType();
        Type rhsType = this.rhs.getType();
        return lhsType;
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        Type lhsType = this.lhs.getType();
        Type rhsType = this.rhs.getType();
        if (!this.rhs.isAssignableTo(lhsType)) {
            this.rhs.showTypeError(this.rhs.getType(), lhsType);
        }
        return this;
    }

    public ASTObject fixAccessToFieldSet(FieldAccessExpr expr) {
        return this.getAST().makeCall(expr.getField().getBackdoorSetterMethod(), expr.getExpr(), this.getRhs());
    }

    public void walkFlow(FlowCheckerPass w) {
        if (this.getLhs() instanceof VarExpr) {
            w.process(this.getRhs());
            VarExpr lhs = (VarExpr)this.getLhs();
            VarDec dec = lhs.getVarDec();
            if (dec.isFinal()) {
                if (!dec.isBlank()) {
                    w.showVarError(this, dec, "Final variable " + dec.getId() + " already has a value");
                } else if (!w.getVars().isDefinitelyUnassigned(dec)) {
                    w.showVarError(this, dec, "Final variable " + dec.getId() + " may already have a value");
                } else {
                    w.addPossiblyAssigned(dec);
                }
            }
            w.setVars(w.getVars().addAssigned(dec));
        } else if (this.getLhs() instanceof FieldAccessExpr) {
            FieldAccessExpr lhs = (FieldAccessExpr)this.getLhs();
            FieldDec dec = lhs.getFieldDec();
            if (lhs.isBare()) {
                w.process(this.getRhs());
                if (dec.isFinal()) {
                    if (!dec.isBlank()) {
                        w.showVarError(this, dec, "Final field " + dec.getId() + " already has a value");
                    } else if (!w.getVars().isDefinitelyUnassigned(dec)) {
                        w.showVarError(this, dec, "Final field " + dec.getId() + " may already have a value");
                    } else {
                        w.addPossiblyAssigned(dec);
                        w.setVars(w.getVars().addAssigned(dec));
                    }
                }
            } else {
                w.process(lhs.getExpr());
                w.process(this.getRhs());
                if (!(!dec.isFinal() || dec.isBlank() && w.getVars().isDefinitelyUnassigned(dec))) {
                    w.showVarError(this, dec, "Final field " + dec.getId() + " already has a value");
                }
            }
        } else {
            w.process(this.getLhs());
            w.process(this.getRhs());
        }
    }

    protected void cgValue(CodeBuilder cb) {
        this.cgValueEffect(cb, true);
    }

    protected void cgEffect(CodeBuilder cb) {
        this.cgValueEffect(cb, false);
    }

    private void cgValueEffect(CodeBuilder cb, boolean needsValue) {
        AssignableExpr lhs = this.getLhs();
        Expr rhs = this.getRhs();
        lhs.cgLvalue(cb);
        rhs.cgValue(cb, lhs.getType());
        if (needsValue) {
            lhs.cgDupRvalue(cb);
        }
        lhs.cgAssignment(cb);
    }

    public BasicAssignExpr(SourceLocation location, AssignableExpr _lhs, String _op, Expr _rhs) {
        super(location, _lhs, _op, _rhs);
    }

    protected BasicAssignExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        BasicAssignExpr ret = new BasicAssignExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.lhs != null) {
            ret.setLhs((AssignableExpr)walker.process(this.lhs));
        }
        ret.op = this.op;
        if (this.rhs != null) {
            ret.setRhs((Expr)walker.process(this.rhs));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "BasicAssignExpr(op: " + this.op + ")";
    }
}

