/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;

public class ArrayInitializer
extends Expr {
    protected Exprs exprs;

    protected Type discoverType() {
        return this.getTypeManager().anyType;
    }

    public void unparse(CodeWriter writer) throws IOException {
        writer.openParen('{');
        writer.write(this.exprs);
        writer.closeParen('}');
    }

    public void cleanup() {
        this.exprs = null;
        super.cleanup();
    }

    public Exprs getExprs() {
        return this.exprs;
    }

    public void setExprs(Exprs _exprs) {
        if (_exprs != null) {
            _exprs.setParent(this);
        }
        this.exprs = _exprs;
    }

    public ArrayInitializer(SourceLocation location, Exprs _exprs) {
        super(location);
        this.setExprs(_exprs);
    }

    protected ArrayInitializer(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ArrayInitializer ret = new ArrayInitializer(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.exprs != null) {
            ret.setExprs((Exprs)walker.process(this.exprs));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.exprs;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "exprs";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setExprs((Exprs)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "ArrayInitializer()";
    }
}

