/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ConditionalOpExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class AndAndOpExpr
extends ConditionalOpExpr {
    protected LiteralExpr halfFold(Type type, LiteralExpr lit1, LiteralExpr lit2) {
        return type.foldBitwiseOp("&", lit1, lit2);
    }

    public void walkFlow(FlowCheckerPass w) {
        w.processBoolean(this.getRand1());
        FlowCheckerPass.Vars p1 = w.getVars();
        w.setVars(p1.getTrue());
        w.processBoolean(this.getRand2());
        FlowCheckerPass.Vars p2 = w.getVars();
        w.setVars(p2.getTrue(), p1.getFalse().join(p2.getFalse()));
    }

    public ASTObject postCleanup(ByteCodeCleanupPass w) {
        if (this.getRand1().isConstantTrue()) {
            return this.getRand2();
        }
        if (this.getRand1().isConstantFalse() || this.getRand2().isConstantTrue()) {
            return this.getRand1();
        }
        return this;
    }

    protected void cgTest(CodeBuilder cb, Label tdest, Label fdest) {
        Label mid = cb.genLabel();
        this.getRand1().cgTest(cb, mid, fdest);
        cb.emitLabel(mid);
        this.getRand2().cgTest(cb, tdest, fdest);
    }

    public AndAndOpExpr(SourceLocation location, Expr _rand1, String _op, Expr _rand2) {
        super(location, _rand1, _op, _rand2);
    }

    protected AndAndOpExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        AndAndOpExpr ret = new AndAndOpExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.rand1 != null) {
            ret.setRand1((Expr)walker.process(this.rand1));
        }
        ret.op = this.op;
        if (this.rand2 != null) {
            ret.setRand2((Expr)walker.process(this.rand2));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "AndAndOpExpr(op: " + this.op + ")";
    }
}

