/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BinopExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class AddOpExpr
extends BinopExpr {
    void checkAssignmentOperatorType() {
        Type ty1 = this.getRand1().getType();
        Type ty2 = this.getRand2().getType();
        if (ty1.isVoid() || ty2.isVoid()) {
            this.showOperatorTypeError("+", ty1, ty2);
        } else if (!(ty1.isAnyType() || ty2.isAnyType() || ty1.isString() || ty2.isString() || ty1.isNumeric() && ty2.isNumeric())) {
            this.showOperatorTypeError("+", ty1, ty2);
        }
    }

    protected LiteralExpr halfFold(Type type, LiteralExpr lit1, LiteralExpr lit2) {
        return type.foldAddOp(lit1, lit2);
    }

    protected Type discoverType() {
        Expr rand1 = this.getRand1();
        Expr rand2 = this.getRand2();
        Type ty1 = rand1.getType();
        Type ty2 = rand2.getType();
        if (ty1.isAnyType() || ty2.isAnyType()) {
            return this.getTypeManager().anyType;
        }
        if (ty1.isVoid() || ty2.isVoid()) {
            this.showOperatorTypeError("+", ty1, ty2);
            return this.getTypeManager().anyType;
        }
        if (ty1.isString() || ty2.isString()) {
            return this.getTypeManager().getStringType();
        }
        if (ty1.isNumeric() && ty2.isNumeric()) {
            return this.getTypeManager().binaryNumericPromotion(ty1, ty2);
        }
        this.showOperatorTypeError("+", ty1, ty2);
        return this.getTypeManager().anyType;
    }

    protected Type getLiftType() {
        return this.getType();
    }

    protected void cgValue(CodeBuilder cb) {
        Type liftTy = this.getLiftType();
        if (liftTy.isString()) {
            NameType stringBufferType = this.getTypeManager().getStringBufferType();
            cb.emitNEW(stringBufferType);
            cb.emitDUP();
            cb.emitINVOKESPECIAL(stringBufferType, "<init>", "()V", -1);
            this.rand1.cgBuffer(cb);
            this.rand2.cgBuffer(cb);
            cb.emitINVOKEVIRTUAL(stringBufferType, "toString", "()Ljava/lang/String;", 0);
        } else {
            this.rand1.cgValue(cb, liftTy);
            this.rand2.cgValue(cb, liftTy);
            liftTy.emitAdd(cb);
        }
    }

    protected void cgBuffer(CodeBuilder cb) {
        if (this.getType().isString()) {
            this.rand1.cgBuffer(cb);
            this.rand2.cgBuffer(cb);
        } else {
            super.cgBuffer(cb);
        }
    }

    protected void cgOp(CodeBuilder cb, Type ty) {
        ty.emitAdd(cb);
    }

    public AddOpExpr(SourceLocation location, Expr _rand1, String _op, Expr _rand2) {
        super(location, _rand1, _op, _rand2);
    }

    protected AddOpExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        AddOpExpr ret = new AddOpExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.rand1 != null) {
            ret.setRand1((Expr)walker.process(this.rand1));
        }
        ret.op = this.op;
        if (this.rand2 != null) {
            ret.setRand2((Expr)walker.process(this.rand2));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "AddOpExpr(op: " + this.op + ")";
    }
}

