/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ForwardReferenceChecker;
import org.aspectj.compiler.base.FrameLocPass;
import org.aspectj.compiler.base.InnerAccessFixer;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.LocalClassPass;
import org.aspectj.compiler.base.MemberClassMunger;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.Comment;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.SourceSourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.crosscuts.AccessFixer;
import org.aspectj.compiler.crosscuts.IntroductionPlannerPass;
import org.aspectj.compiler.crosscuts.MixinImplementationPass;

public abstract class ASTObject
extends CompilerObject {
    protected SourceLocation sourceLocation = null;
    protected ASTObject parent;

    public ASTObject(SourceLocation loc) {
        super(loc.getCompiler());
        this.sourceLocation = loc;
    }

    public boolean hasSourceLocation() {
        return this.sourceLocation != null;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(SourceLocation newLocation) {
        this.sourceLocation = newLocation;
    }

    public int getStartPosition() {
        return this.getSourceLocation().getStartPosition();
    }

    public int getEndPosition() {
        return this.getSourceLocation().getEndPosition();
    }

    public int getBeginLine() {
        return this.getSourceLocation().getBeginLine();
    }

    public int getEndLine() {
        return this.getSourceLocation().getEndLine();
    }

    public int getBeginColumn() {
        return this.getSourceLocation().getBeginColumn();
    }

    public int getEndColumn() {
        return this.getSourceLocation().getBeginLine();
    }

    public Comment getComment() {
        return this.getSourceLocation().getComment();
    }

    public void addComment(Comment _comment) {
        this.getSourceLocation().addComment(_comment);
    }

    public boolean isSynthetic() {
        return this.getSourceLocation().isSynthetic();
    }

    public boolean isLanguageVisible() {
        return !this.getSourceLocation().isSynthetic();
    }

    public void setFormalComment(String comment) {
        this.getSourceLocation().setFormalComment(comment);
    }

    public String getFormalComment() {
        return this.getSourceLocation().getFormalComment();
    }

    public void clearComment() {
        this.getSourceLocation().clearComment();
    }

    public CompilationUnit getCompilationUnit() {
        return this.getSourceLocation().getCompilationUnit();
    }

    public File getSourceFile() {
        return this.getSourceLocation().getSourceFile();
    }

    public final String getSourceFileName() {
        return this.getSourceLocation().getSourceFileName();
    }

    public final String getSourceDirectoryName() {
        return this.getSourceLocation().getSourceDirectoryName();
    }

    public boolean hasSource() {
        return this.getSourceLocation().hasSource();
    }

    public boolean fromSource() {
        return this.getSourceLocation().fromSource();
    }

    public void setParent(ASTObject x) {
        if (this.getOptions().strictTree && this.parent != null && this.parent != x) {
            this.showError("changing parent from " + this.parent + " to " + x);
        }
        this.parent = x;
    }

    public ASTObject getParent() {
        return this.parent;
    }

    public int getChildCount() {
        return 0;
    }

    public ASTObject getChildAt(int childIndex) {
        return null;
    }

    public String getChildNameAt(int childIndex) {
        return null;
    }

    public void setChildAt(int childIndex, ASTObject child) {
    }

    public void removeChildAt(int childIndex) {
        this.remove(childIndex);
    }

    public void remove(int index) {
        this.setChildAt(index, null);
    }

    public void remove(ASTObject child) {
        int index = this.indexOf(child);
        if (index == -1) {
            throw new IllegalArgumentException("not a child");
        }
        this.remove(index);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public int indexOf(ASTObject node) {
        int n = this.getChildCount();
        int i = 0;
        while (i < n) {
            ASTObject child = this.getChildAt(i);
            if (child != null && child == node) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean contains(ASTObject node) {
        return this.indexOf(node) != -1;
    }

    public boolean hasLegalProtectedAccess(Type fromType) {
        return true;
    }

    public final boolean containsTypes() {
        if (this instanceof TypeDec) {
            return true;
        }
        int i = 0;
        int n = this.getChildCount();
        while (i < n) {
            ASTObject child = this.getChildAt(i);
            if (child != null && child.containsTypes()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void walkForwardReference(ForwardReferenceChecker w) {
        this.walk(w);
    }

    public void walkFlow(FlowCheckerPass w) {
        this.walk(w);
    }

    public void walkFrameLoc(FrameLocPass walker) {
        this.walk(walker);
    }

    public void preMove(MovingWalker walker) {
    }

    public ASTObject postMove(MovingWalker walker) {
        return this;
    }

    public ASTObject fixAccessPost(AccessFixer fixer) {
        return this;
    }

    public ASTObject copyWalk(CopyWalker walker) {
        return null;
    }

    public ASTObject postCopy(CopyWalker walker, ASTObject oldObject) {
        return this;
    }

    public void preCopy(CopyWalker walker, ASTObject oldObject) {
    }

    public void preIntroduction(IntroductionPlannerPass pass) {
    }

    public void preScope(ScopeWalker walker) {
    }

    public ASTObject postScope(ScopeWalker walker) {
        return this;
    }

    public void walkScope(ScopeWalker walker) {
        this.walk(walker);
    }

    public void walk(Walker walker) {
        int i = 0;
        while (i < this.getChildCount()) {
            ASTObject child = this.getChildAt(i);
            if (child != null) {
                ASTObject newChild;
                if (this.getOptions().strictTree && child.getParent() != this) {
                    child.showError("wrong parent: " + this.unparse() + " '" + child.unparse() + "'");
                    System.out.println(child.getParent().unparse());
                }
                if ((newChild = walker.process(child)) != child) {
                    if (newChild == null) {
                        this.removeChildAt(i);
                        --i;
                    } else {
                        this.setChildAt(i, newChild);
                    }
                }
            }
            ++i;
        }
    }

    public Type getOutermostLexicalType() {
        if (this.parent == null) {
            return this.getTypeManager().TYPE_NOT_FOUND;
        }
        return this.parent.getOutermostLexicalType();
    }

    public Type getOutermostBytecodeType() {
        if (this.parent == null) {
            return this.getTypeManager().TYPE_NOT_FOUND;
        }
        return this.parent.getOutermostBytecodeType();
    }

    public Type getLexicalType() {
        if (this.getParent() == null) {
            return null;
        }
        if (this instanceof Decs && this.getParent() instanceof TypeDec) {
            return ((TypeDec)this.getParent()).getType();
        }
        return this.getParent().getLexicalType();
    }

    public Type getDeclaringType() {
        if (this.getParent() == null) {
            return null;
        }
        if (this.getParent() instanceof TypeDec) {
            return ((TypeDec)this.getParent()).getType();
        }
        return this.getParent().getDeclaringType();
    }

    public TypeDec getBytecodeTypeDec() {
        if (this.getParent() == null) {
            this.showError("no parent: " + this + ": " + System.identityHashCode(this));
            System.out.println(this.unparse());
            return this.getTypeManager().TYPE_DEC_NOT_FOUND;
        }
        if (this.getParent() instanceof TypeDec) {
            return (TypeDec)this.getParent();
        }
        return this.getParent().getBytecodeTypeDec();
    }

    public Type getBytecodeType() {
        TypeDec dec = this.getBytecodeTypeDec();
        if (dec == null) {
            return null;
        }
        return dec.getType();
    }

    public Dec getEnclosingDec() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getEnclosingDec();
    }

    public CodeDec getEnclosingCodeDec() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getEnclosingCodeDec();
    }

    public boolean inStaticContext() {
        if (this.getParent() == null) {
            return true;
        }
        return this.getParent().inStaticContext();
    }

    public void showTypeError(Type foundType, Type requiredType) {
        if (foundType.isMissing() || requiredType.isMissing()) {
            return;
        }
        this.showError("incompatible types\nfound   : " + foundType.getString() + "\n" + "required: " + requiredType.getString());
    }

    public void showError(String message) {
        this.getCompiler().showError(this, message);
    }

    public void showWarning(String message) {
        this.getCompiler().showWarning(this, message);
    }

    public void showMessage(String message) {
        this.getCompiler().showMessage(this, message);
    }

    public String toShortString() {
        return this.getClass().getName();
    }

    public ASTObject copy() {
        return CopyWalker.copy(this);
    }

    public void checkNoSharing(ASTObject other) {
        HashSet s1 = new HashSet();
        HashSet s2 = new HashSet();
        this.addContainedNodes(s1);
        other.addContainedNodes(s2);
        s1.retainAll(s2);
        if (!s1.isEmpty()) {
            this.getCompiler().showError(this, "shares nodes with " + other + "\n" + s1);
        }
    }

    private void addContainedNodes(Set ret) {
        if (ret.contains(this)) {
            this.getCompiler().showError(this, "duplicate node in " + ret);
        }
        ret.add(this);
        int i = 0;
        while (i < this.getChildCount()) {
            ASTObject o = this.getChildAt(i);
            if (o != null) {
                o.addContainedNodes(ret);
            }
            ++i;
        }
    }

    public ASTObject setSource(ASTObject sourceObject) {
        this.sourceLocation = sourceObject.sourceLocation;
        return this;
    }

    public ASTObject setSyntheticSource(ASTObject sourceObject) {
        this.sourceLocation = new SourceSourceLocation(sourceObject);
        return this;
    }

    protected void makeChild(ASTObject object) {
        if (object != null) {
            object.parent = this;
        }
    }

    protected void makeChild(ASTObject[] array) {
        if (array == null) {
            return;
        }
        int n = array.length;
        int i = 0;
        while (i < n) {
            this.makeChild(array[i]);
            ++i;
        }
    }

    public String getDefaultDisplayName() {
        return this.getClass().getName();
    }

    public void clearParent() {
        this.parent = null;
    }

    protected void setParents() {
    }

    public void replaceWith(ASTObject other) {
        ASTObject parent = this.getParent();
        if (parent == null) {
            this.showWarning("no parent to replace in");
            this.display(2);
            return;
        }
        int i = parent.indexOf(this);
        if (i == -1) {
            this.showError("invalid replacement attempt, not in: " + parent);
            parent.display(2);
            return;
        }
        parent.setChildAt(i, other);
    }

    public String toString() {
        return this.getDefaultDisplayName();
    }

    public void display(int indent) {
        int s = 0;
        while (s < indent) {
            System.out.print(" ");
            ++s;
        }
        System.out.println(this.getDefaultDisplayName() + System.identityHashCode(this));
        int N = this.getChildCount();
        int i = 0;
        while (i < N) {
            ASTObject child = this.getChildAt(i);
            if (child != null) {
                child.display(indent + 1);
            }
            ++i;
        }
    }

    public AST getAST() {
        return new AST(new SourceSourceLocation(this));
    }

    public String unparse() {
        CodeWriter writer = new CodeWriter(this.getCompiler());
        writer.write(this);
        return writer.getString();
    }

    public void unparse(CodeWriter writer) throws IOException {
        writer.write("/* ");
        writer.write(this.getDefaultDisplayName());
        writer.write(" */");
        writer.newLine();
    }

    public void cleanup() {
    }

    public void fixAST(ASTFixerPass fixer) {
        this.walk(fixer);
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        return this;
    }

    public void implementMixin(MixinImplementationPass walker) {
        this.walk(walker);
    }

    public ASTObject postImplementMixin(MixinImplementationPass walker) {
        return this;
    }

    public void walkInnerInfo(InnerInfoPass walker) {
        this.walk(walker);
    }

    public void postInnerInfo(InnerInfoPass walker) {
    }

    public void checkSpec() {
    }

    public void preAssignmentCheck(AssignmentCheckerPass walker) {
    }

    public void walkAssignmentCheck(AssignmentCheckerPass walker) {
        this.walk(walker);
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        return this;
    }

    public void walkAnalysis(LocalClassPass.AnalysisWalker walker) {
        this.walk(walker);
    }

    public void preLift(LocalClassPass.LiftWalker walker) {
    }

    public ASTObject postLift(LocalClassPass.LiftWalker walker) {
        return this;
    }

    public void preThreading(LocalClassPass.ThreadingWalker walker) {
    }

    public ASTObject postThreading(LocalClassPass.ThreadingWalker walker) {
        return this;
    }

    public ASTObject walkMemberMunger(MemberClassMunger w) {
        this.walk(w);
        return this;
    }

    public ASTObject postInnerAccess(InnerAccessFixer w) {
        return this;
    }

    public MethodDec buildAccessMethod(InnerAccessFixer w) {
        throw new RuntimeException("No access method should be built for " + this);
    }

    public void walkCleanup(ByteCodeCleanupPass walker) {
        this.walk(walker);
    }

    public ASTObject postCleanup(ByteCodeCleanupPass walker) {
        return this;
    }
}

