/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.Options;
import org.aspectj.compiler.base.ast.BooleanType;
import org.aspectj.compiler.base.ast.ByteType;
import org.aspectj.compiler.base.ast.CharType;
import org.aspectj.compiler.base.ast.ClassDec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.DoubleType;
import org.aspectj.compiler.base.ast.DummySourceLocation;
import org.aspectj.compiler.base.ast.FloatType;
import org.aspectj.compiler.base.ast.IntType;
import org.aspectj.compiler.base.ast.LongType;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.NotFoundType;
import org.aspectj.compiler.base.ast.NullType;
import org.aspectj.compiler.base.ast.PackageSO;
import org.aspectj.compiler.base.ast.PrimitiveType;
import org.aspectj.compiler.base.ast.ShortType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.VoidType;
import org.aspectj.compiler.base.bytecode.ClassPathManager;

public final class TypeManager
extends CompilerObject {
    protected SourceLocation dummySource = new DummySourceLocation(this.getCompiler());
    public final TypeDec TYPE_DEC_NOT_FOUND = new ClassDec(this.dummySource, new Modifiers(this.dummySource, 0), "*NF*", null, null, new Decs(this.dummySource));
    public final NameType TYPE_NOT_FOUND = new NotFoundType(this.TYPE_DEC_NOT_FOUND);
    private ClassPathManager classPathManager;
    private Map packages;
    private PackageSO defaultPackage;
    private Collection loadedTypes;
    private Collection allVisibleTypeNames;
    private final Map primitiveTypeMap;
    public final Type nullType;
    public final Type voidType;
    public final Type anyType;
    public final PrimitiveType intType;
    public final PrimitiveType byteType;
    public final PrimitiveType shortType;
    public final PrimitiveType longType;
    public final PrimitiveType doubleType;
    public final PrimitiveType floatType;
    public final PrimitiveType charType;
    public final PrimitiveType booleanType;

    public TypeManager(JavaCompiler compiler) {
        super(compiler);
        this.TYPE_DEC_NOT_FOUND.setType(this.TYPE_NOT_FOUND);
        this.packages = new HashMap();
        this.loadedTypes = new HashSet();
        this.allVisibleTypeNames = null;
        this.primitiveTypeMap = new HashMap();
        this.nullType = new NullType(this.getCompiler());
        this.voidType = new VoidType(this.getCompiler());
        this.primitiveTypeMap.put("void", this.voidType);
        this.anyType = this.TYPE_NOT_FOUND;
        this.intType = new IntType(this.getCompiler());
        this.primitiveTypeMap.put("int", this.intType);
        this.byteType = new ByteType(this.getCompiler());
        this.primitiveTypeMap.put("byte", this.byteType);
        this.shortType = new ShortType(this.getCompiler());
        this.primitiveTypeMap.put("short", this.shortType);
        this.longType = new LongType(this.getCompiler());
        this.primitiveTypeMap.put("long", this.longType);
        this.doubleType = new DoubleType(this.getCompiler());
        this.primitiveTypeMap.put("double", this.doubleType);
        this.floatType = new FloatType(this.getCompiler());
        this.primitiveTypeMap.put("float", this.floatType);
        this.charType = new CharType(this.getCompiler());
        this.primitiveTypeMap.put("char", this.charType);
        this.booleanType = new BooleanType(this.getCompiler());
        this.primitiveTypeMap.put("boolean", this.booleanType);
        Options options = compiler.getOptions();
        if (options.classpath == null) {
            options.classpath = options.defaultClasspath;
        }
        this.classPathManager = new ClassPathManager(compiler, options.classpath, options.bootclasspath, options.extdirs);
        this.defaultPackage = new PackageSO(compiler, null, this.classPathManager);
    }

    public Collection getAllVisibleTypeNames() {
        if (this.allVisibleTypeNames == null) {
            this.allVisibleTypeNames = this.classPathManager.getAllPossibleTypeNames();
            Iterator i = this.getWorld().getTypes().iterator();
            while (i.hasNext()) {
                TypeDec t = (TypeDec)i.next();
                this.allVisibleTypeNames.add(t.getType().getNamePieces());
            }
            Iterator i2 = this.getPrimitiveTypeMap().values().iterator();
            while (i2.hasNext()) {
                Type t = (Type)i2.next();
                this.allVisibleTypeNames.add(t.getNamePieces());
            }
        }
        return this.allVisibleTypeNames;
    }

    public Collection getClassPathStrings() {
        return this.classPathManager.getPathStrings();
    }

    public Collection getLoadedTypes() {
        return this.loadedTypes;
    }

    public Type getType(String packageName, String className) {
        Type type = this.findType(packageName, className);
        if (type == null) {
            this.getCompiler().showError("missing type " + packageName + '.' + className);
            return this.TYPE_NOT_FOUND;
        }
        return type;
    }

    public synchronized Type findType(String packageName, String className) {
        PackageSO p = this.findPackage(packageName);
        Type ret = p.findType(className);
        if (ret != null) {
            this.loadedTypes.add(ret);
        }
        return ret;
    }

    public void addType(Type type) {
        PackageSO p = this.findPackage(type.getPackageName());
        p.addType(type);
        this.loadedTypes.add(type);
    }

    PackageSO findTopLevelPackage(String name) {
        PackageSO p = (PackageSO)this.packages.get(name);
        if (p != null) {
            return p;
        }
        p = new PackageSO(this.getCompiler(), name, this.classPathManager.makeSubPackageManager(name));
        this.packages.put(name, p);
        return p;
    }

    public PackageSO findPackage(String packageName) {
        if (packageName == null) {
            return this.defaultPackage;
        }
        PackageSO p = (PackageSO)this.packages.get(packageName);
        if (p != null) {
            return p;
        }
        String[] names = this.splitDottedName(packageName);
        p = this.findTopLevelPackage(names[0]);
        int i = 1;
        while (i < names.length) {
            p = p.findPackage(names[i]);
            ++i;
        }
        this.packages.put(packageName, p);
        return p;
    }

    String[] splitDottedName(String name) {
        int nameCount = 0;
        int lastDot = -1;
        do {
            lastDot = name.indexOf(46, lastDot + 1);
            ++nameCount;
        } while (lastDot != -1);
        String[] names = new String[nameCount];
        lastDot = 0;
        int index = 0;
        while (true) {
            int nextDot;
            if ((nextDot = name.indexOf(46, lastDot)) == -1) break;
            names[index++] = name.substring(lastDot, nextDot);
            lastDot = nextDot + 1;
        }
        names[index] = name.substring(lastDot);
        return names;
    }

    public boolean checkLoadable(String packageName, String className) {
        PackageSO p = this.findPackage(packageName);
        return p.findTypeOnClassPath(className) != null;
    }

    public Type findPrimitiveType(String id) {
        return (Type)this.getPrimitiveTypeMap().get(id);
    }

    public Map getPrimitiveTypeMap() {
        return this.primitiveTypeMap;
    }

    public final NameType getObjectType() {
        return (NameType)this.getType("java.lang", "Object");
    }

    public final NameType getStringType() {
        return (NameType)this.getType("java.lang", "String");
    }

    public final NameType getClassType() {
        return (NameType)this.getType("java.lang", "Class");
    }

    public final NameType getCloneableType() {
        return (NameType)this.getType("java.lang", "Cloneable");
    }

    public final NameType getSerializableType() {
        return (NameType)this.getType("java.io", "Serializable");
    }

    public final NameType getRuntimeExceptionType() {
        return (NameType)this.getType("java.lang", "RuntimeException");
    }

    public final NameType getErrorType() {
        return (NameType)this.getType("java.lang", "Error");
    }

    public final NameType getThrowableType() {
        return (NameType)this.getType("java.lang", "Throwable");
    }

    public final NameType getExceptionType() {
        return (NameType)this.getType("java.lang", "Exception");
    }

    public final NameType getStringBufferType() {
        return (NameType)this.getType("java.lang", "StringBuffer");
    }

    public final Type getJoinPointType() {
        return this.getType("org.aspectj.lang", "JoinPoint");
    }

    public final Type getJoinPointStaticPartType() {
        return this.getType("org.aspectj.lang", "JoinPoint$StaticPart");
    }

    public final Type getAroundClosureType() {
        return this.getType("org.aspectj.runtime.internal", "AroundClosure");
    }

    public final Type getConversionsType() {
        return this.getType("org.aspectj.runtime.internal", "Conversions");
    }

    public Type unaryNumericPromotion(Type ty) {
        if (ty == this.doubleType || ty == this.floatType || ty == this.longType) {
            return ty;
        }
        return this.intType;
    }

    public Type binaryNumericPromotion(Type ty1, Type ty2) {
        if (ty1 == this.doubleType || ty2 == this.doubleType) {
            return this.doubleType;
        }
        if (ty1 == this.floatType || ty2 == this.floatType) {
            return this.floatType;
        }
        if (ty1 == this.longType || ty2 == this.longType) {
            return this.longType;
        }
        return this.intType;
    }
}

