/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.Set;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.Walker;

class TopTypesFinder
extends Walker {
    private Set topTypesSet;

    public TopTypesFinder(JavaCompiler compiler, Set topTypesSet) {
        super(compiler);
        this.topTypesSet = topTypesSet;
    }

    public void postProcess(ASTObject obj) {
        if (obj instanceof TypeD) {
            Type type = ((TypeD)obj).getType();
            if (type.getPackageName() == null) {
                this.topTypesSet.add(type);
            }
        } else if (obj instanceof FieldAccessExpr) {
            FieldAccessExpr fae = (FieldAccessExpr)obj;
            if (fae.getField() == null) {
                return;
            }
            if (fae.getField().isStatic()) {
                Type type = fae.getField().getDeclaringType();
                if (type != null && type.getPackageName() == null) {
                    this.topTypesSet.add(type);
                }
                return;
            }
        }
    }
}

