/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.aspectj.compiler.base.AbstractCompilerPass;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.ast.Walker;

public class LocalClassPass
extends AbstractCompilerPass {
    public LocalClassPass(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDisplayName() {
        return "lifting local classes ";
    }

    public void transform(TypeDec typeDec) {
        AnalysisWalker analysisWalker = new AnalysisWalker(this.getCompiler());
        analysisWalker.process(typeDec);
        new LiftWalker(this.getCompiler()).process(typeDec);
        new ThreadingWalker(this.getCompiler(), analysisWalker).process(typeDec);
    }

    public static class AnalysisWalker
    extends Walker {
        private static final int NOWHERE = 0;
        private static final int DYNAMIC = 1;
        private static final int SEMI_STATIC = 2;
        private static final int NIGH_STATIC = 3;
        private static final int STATIC = 4;
        private int context = 0;
        HashMap needsVarTable = new HashMap();
        HashMap needsFieldTable = new HashMap();
        private Stack contextStack = new Stack();
        private int localCounter = 0;

        AnalysisWalker(JavaCompiler compiler) {
            super(compiler);
        }

        public ASTObject process(ASTObject object) {
            int saved = this.context;
            object.walkAnalysis(this);
            this.context = saved;
            return object;
        }

        public void inType() {
            this.context = 0;
        }

        public void inConstructor() {
            this.context = 2;
        }

        public void inConstructorCall() {
            this.context = 3;
        }

        public void inCode(boolean isStatic) {
            this.context = isStatic ? 4 : 1;
        }

        public void enterTypeDec(TypeDec typeDec) {
            if (this.context == 3 || this.context == 4) {
                typeDec.getModifiers().setStatic(true);
            }
            this.contextStack.push(new Integer(this.context));
            this.contextStack.push(typeDec);
        }

        public void leaveTypeDec() {
            this.contextStack.pop();
            this.contextStack.pop();
        }

        public void enterCodeDec(CodeDec codeDec) {
            this.contextStack.push(codeDec);
        }

        public void leaveCodeDec() {
            this.contextStack.pop();
        }

        public void processVarExpr(VarExpr varExpr) {
            VarDec varDec = varExpr.getVarDec();
            CodeDec referenceContextDec = varDec.getEnclosingCodeDec();
            int referenceContext = this.context;
            if (this.contextStack.peek() == referenceContextDec) {
                return;
            }
            if (!varDec.isFinal()) {
                varExpr.showError("local variable " + varDec.getId() + " is referenced from inside inner class; " + " needs to be declared final");
                return;
            }
            int i = this.contextStack.size() - 2;
            while (i >= 0) {
                if (referenceContext == 4) {
                    varExpr.showError("Not accessible from static context");
                    break;
                }
                TypeDec typeDec = (TypeDec)this.contextStack.get(i);
                int typeDecContext = (Integer)this.contextStack.get(i - 1);
                CodeDec maybeDeclarationContextDec = (CodeDec)this.contextStack.get(i - 2);
                if (maybeDeclarationContextDec == referenceContextDec) {
                    AnalysisWalker.addToTable(this.needsVarTable, typeDec, varDec);
                    AnalysisWalker.addToTable(this.needsFieldTable, typeDec, varDec);
                    break;
                }
                if (typeDecContext == 3) {
                    AnalysisWalker.addToTable(this.needsVarTable, typeDec, varDec);
                    if (referenceContext == 1) {
                        AnalysisWalker.addToTable(this.needsFieldTable, typeDec, varDec);
                    }
                    referenceContext = 3;
                } else {
                    referenceContext = 1;
                }
                i -= 3;
            }
        }

        private static void addToTable(HashMap map, Object key, Object elem) {
            Object o = map.get(key);
            if (o == null) {
                HashSet<Object> s = new HashSet<Object>();
                s.add(elem);
                map.put(key, s);
            } else {
                ((Set)o).add(elem);
            }
        }

        public String makeNewId(TypeDec typeDec) {
            return typeDec.isAnonymous() ? "_" + ++this.localCounter + "" : "_" + ++this.localCounter + "_" + typeDec.getId();
        }
    }

    public static class LiftWalker
    extends Walker {
        private Stack decsStack = new Stack();
        private Decs decs = this.getAST().makeDecs();

        LiftWalker(JavaCompiler compiler) {
            super(compiler);
        }

        public ASTObject process(ASTObject object) {
            object.preLift(this);
            object.walk(this);
            return object.postLift(this);
        }

        public void pushPendingDecs() {
            this.decsStack.push(this.getAST().makeDecs());
        }

        public void addToPendingDecs(TypeDec dec) {
            ((Decs)this.decsStack.peek()).add(dec);
        }

        public void popPendingDecsInto(TypeDec dec) {
            dec.getBody().addAll((Decs)this.decsStack.pop());
        }
    }

    public static class ThreadingWalker
    extends Walker {
        HashMap needsVarTable;
        HashMap needsFieldTable;
        Stack typeContext = new Stack();
        Stack fieldContext = new Stack();
        Stack env = new Stack();

        ThreadingWalker(JavaCompiler compiler, AnalysisWalker analysisWalker) {
            super(compiler);
            this.fieldContext.push(new HashMap());
            this.needsVarTable = analysisWalker.needsVarTable;
            this.needsFieldTable = analysisWalker.needsFieldTable;
        }

        public ASTObject process(ASTObject object) {
            object.preThreading(this);
            object.walk(this);
            return object.postThreading(this);
        }

        public void pushConstructorEnv(Formals formals) {
            AST ast = this.getAST();
            HashMap<VarDec, FormalDec> envMap = new HashMap<VarDec, FormalDec>();
            Set s = (Set)this.needsVarTable.get(this.typeContext.peek());
            if (s != null) {
                Iterator i = s.iterator();
                while (i.hasNext()) {
                    VarDec varDec = (VarDec)i.next();
                    FormalDec formalDec = ast.makeFormal(varDec.getTypeD().getType(), "val$" + varDec.getId());
                    formals.add(0, formalDec);
                    envMap.put(varDec, formalDec);
                }
            }
            this.env.push(envMap);
        }

        public void pushNonConstructorEnv() {
            this.env.push(this.fieldContext.peek());
        }

        public void popEnv() {
            this.env.pop();
        }

        public void pushTypeDec(TypeDec typeDec) {
            this.respectOurParentsWishes(typeDec);
            this.typeContext.push(typeDec);
            this.addFields(typeDec);
        }

        public void popTypeDec() {
            this.typeContext.pop();
            this.fieldContext.pop();
        }

        private void addFields(TypeDec typeDec) {
            AST ast = this.getAST();
            HashMap<VarDec, FieldDec> envMap = new HashMap<VarDec, FieldDec>();
            Set s = (Set)this.needsFieldTable.get(this.typeContext.peek());
            if (s != null) {
                Iterator i = s.iterator();
                while (i.hasNext()) {
                    VarDec varDec = (VarDec)i.next();
                    FieldDec fieldDec = ast.makeField(ast.makeModifiers(16), varDec.getTypeD().getType(), "val$" + varDec.getId());
                    typeDec.getBody().add(fieldDec);
                    envMap.put(varDec, fieldDec);
                }
            }
            this.fieldContext.push(envMap);
        }

        private void respectOurParentsWishes(TypeDec typeDec) {
            HashSet weNeed = (HashSet)this.needsVarTable.get(typeDec);
            Set parentNeeds = (Set)this.needsVarTable.get(typeDec.getSuperClassType().getTypeDec());
            Set enclosingHas = typeDec.isInner() ? (Set)this.needsVarTable.get(typeDec.getEnclosingInstanceTypeDec()) : null;
            if (weNeed == null) {
                if (parentNeeds != null) {
                    weNeed = new HashSet(parentNeeds);
                    if (enclosingHas != null) {
                        weNeed.removeAll(enclosingHas);
                    }
                    this.needsVarTable.put(typeDec, weNeed);
                }
            } else {
                if (parentNeeds != null) {
                    weNeed.addAll(parentNeeds);
                }
                if (enclosingHas != null) {
                    weNeed.removeAll(enclosingHas);
                }
            }
        }

        public Object lookup(VarDec varDec) {
            int i = this.env.size() - 1;
            while (i >= 0) {
                HashMap map = (HashMap)this.env.get(i);
                Object o = map.get(varDec);
                if (o != null) {
                    return o;
                }
                --i;
            }
            return null;
        }

        public void addArgs(Exprs args, TypeDec typeDec) {
            AST ast = this.getAST();
            Set s = (Set)this.needsVarTable.get(typeDec);
            if (s == null) {
                return;
            }
            Iterator i = s.iterator();
            while (i.hasNext()) {
                args.add(0, ast.makeVar((VarDec)i.next()));
            }
        }

        public void addFieldSets(Stmts stmts) {
            AST ast = this.getAST();
            Iterator i = ((Map)this.fieldContext.peek()).entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                VarDec varDec = (VarDec)entry.getKey();
                FieldDec fieldDec = (FieldDec)entry.getValue();
                stmts.add(0, ast.makeStmt(ast.makeSet(ast.makeDynamicGet(fieldDec), (Expr)ast.makeVar(varDec))));
            }
        }
    }
}

