/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.tools.ide.SourceLine;
import org.aspectj.util.CollectionUtil;

public class LineMap {
    private File outputFile;
    private String outputDirectory;
    private String outputFileName;
    private int outputLine = 0;
    private ASTObject sourceNode = null;
    private Map outputToSource;
    private Map sourceToOutput;

    public LineMap(File outputFile, Map outputToSource, Map sourceToOutput) throws IOException {
        this.outputFile = outputFile;
        this.outputFileName = outputFile.getCanonicalPath();
        this.outputDirectory = new File(this.outputFileName).getParent();
        this.outputToSource = outputToSource;
        this.sourceToOutput = sourceToOutput;
    }

    final String getOutputFile() {
        return this.outputFileName;
    }

    public final boolean hasCurrentSourceLine() {
        return this.sourceNode != null;
    }

    public final int getCurrentSourceLine() {
        return this.sourceNode != null ? this.sourceNode.getBeginLine() : -1;
    }

    public final String getCurrentSourceFile() {
        return this.sourceNode != null ? this.sourceNode.getSourceFileName() : null;
    }

    public final void addLineMappings(SourceLine sourceLine, SourceLine outputLine) {
        Map map;
        Map map2 = map = CollectionUtil.getMapInMap(this.outputToSource, this.outputDirectory);
        synchronized (map2) {
            map.put(outputLine, sourceLine);
        }
        Map map3 = map = CollectionUtil.getMapInMap(this.sourceToOutput, this.sourceNode.getSourceDirectoryName());
        synchronized (map3) {
            map.put(sourceLine, outputLine);
        }
    }

    public final void noteNewLine() {
        if (this.sourceNode != null) {
            this.addLineMappings(new SourceLine(this.sourceNode.getSourceFileName(), this.sourceNode.getBeginLine()), new SourceLine(this.getOutputFile(), this.outputLine));
        }
        ++this.outputLine;
        this.sourceNode = null;
    }

    public final void noteNode(ASTObject node) {
        if (node.getStartPosition() != -1) {
            this.sourceNode = node;
        }
    }
}

