/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.io.PrintWriter;
import org.aspectj.compiler.base.ErrorHandler;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;

public class InternalCompilerError
extends Error {
    public Throwable uncaughtThrowable;
    public ASTObject where;
    private JavaCompiler compiler;
    private String currentSection;

    public InternalCompilerError(JavaCompiler compiler, Throwable uncaughtThrowable, ASTObject where) {
        this.compiler = compiler;
        this.uncaughtThrowable = uncaughtThrowable;
        if (where == null && compiler != null) {
            where = compiler.getCurrentNode();
        }
        this.where = where;
        if (compiler != null) {
            this.currentSection = compiler.getCurrentSection();
        }
    }

    public void showWhere(PrintWriter errorWriter) {
        if (this.currentSection != null) {
            errorWriter.println("The error occured in " + this.currentSection + ".");
            errorWriter.println();
        }
        if (this.where != null) {
            errorWriter.println("At the time of the error, the compiler was processing (" + this.where.getClass().getName() + "):");
            ErrorHandler errorHandler = new ErrorHandler(errorWriter);
            errorHandler.setCompiler(this.compiler);
            errorHandler.showMessage(this.where, "", true, true);
            errorWriter.println();
        }
        errorWriter.flush();
    }
}

