/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.WalkerPass;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.PrimitiveType;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;

public class InnerAccessFixer
extends WalkerPass {
    private Map accessMethods = new HashMap();
    private int accessCounter = 0;

    public InnerAccessFixer(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDisplayName() {
        return "adding inner access backdoors";
    }

    public ASTObject process(ASTObject object) {
        object.walk(this);
        return object.postInnerAccess(this);
    }

    public MethodDec getAccessMethod(Type qType, Dec dec, String op, Expr src) {
        Triple key = new Triple(qType, dec, op);
        MethodDec methodDec = (MethodDec)this.accessMethods.get(key);
        if (methodDec == null) {
            methodDec = src.buildAccessMethod(this);
            ((NameType)qType).getTypeDec().addToBody(methodDec);
            this.accessMethods.put(key, methodDec);
        }
        return methodDec;
    }

    public MethodDec makeAccessMethod(Type returnType, Formals formals, Expr bodyExpr) {
        AST ast = this.getAST();
        return ast.makeMethod(ast.makeModifiers(8), returnType, "access$" + this.accessCounter++, formals, returnType.isVoid() ? ast.makeCodeBody(ast.makeStmt(bodyExpr), ast.makeReturn()) : ast.makeCodeBody(ast.makeReturn(bodyExpr)));
    }

    public Expr makeOutsidePrimary(boolean isStatic, Exprs args, Expr e) {
        if (e.getType() instanceof PrimitiveType) {
            throw new RuntimeException();
        }
        if (isStatic) {
            return e;
        }
        args.add(0, e);
        return this.getAST().makeTypeExpr(e.getType());
    }

    public Expr makeInsidePrimary(boolean isStatic, Formals f, Type ty) {
        AST ast = this.getAST();
        if (isStatic) {
            return ast.makeTypeExpr(ty);
        }
        FormalDec obj = ast.makeFormal(ty, "obj$");
        f.add(0, obj);
        return ast.makeVar(obj);
    }

    public boolean isAccessible(Dec dec, Expr q) {
        if (dec.isPrivate()) {
            return q.getBytecodeTypeDec() == dec.getBytecodeTypeDec();
        }
        if (dec.isProtected()) {
            TypeDec target = dec.getBytecodeTypeDec();
            TypeDec src = q.getBytecodeTypeDec();
            if (src.getType().isSubtypeOf(target.getType())) {
                return true;
            }
            String pkg1 = src.getPackageName();
            String pkg2 = target.getPackageName();
            return pkg1 == null ? pkg2 == null : pkg1.equals(pkg2);
        }
        return true;
    }

    static class Triple {
        Object one;
        Object two;
        Object three;

        Triple(Object one, Object two, Object three) {
            this.one = one;
            this.two = two;
            this.three = three;
        }

        public int hashCode() {
            return this.one.hashCode() + this.two.hashCode() * 2 + this.three.hashCode() * 3;
        }

        public boolean equals(Object other) {
            if (other instanceof Triple) {
                Triple otherTriple = (Triple)other;
                return this.one.equals(otherTriple.one) && this.two.equals(otherTriple.two) && this.three.equals(otherTriple.three);
            }
            return false;
        }
    }
}

