/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.compiler.base.CompilerErrors;
import org.aspectj.compiler.base.InternalCompilerError;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;

public class ErrorHandler {
    private PrintWriter errorWriter;
    private JavaCompiler compiler;
    private static final String PREFIX = "";
    static final String internalErrorMessage = "Please copy the following text into an email message and send it,\nalong with any additional information you can add to:            \n                                                                 \n       support@aspectj.org                            \n                                                                 \n";
    static final String specificCodeRequest = "If you could send us at least that fragment of code, provided it isn't\nconfidential, that would be helpful to us in finding the bug.\n";
    static final String generalCodeRequest = "(If possible, please include a small fragment of code that can \nreproduce the error, provided that code isn't confidential.)   \n";
    private Set firstLines = new HashSet();
    protected int errors = 0;
    protected int warnings = 0;
    public static final Message invalidAbsoluteTypeName = new Message("No match for this type");
    public static final Message invalidWildcardTypeName = new Message("No matches for this type pattern");

    public void setCompiler(JavaCompiler compiler) {
        this.compiler = compiler;
    }

    public JavaCompiler getCompiler() {
        return this.compiler;
    }

    public void cleanupErrorWarningCounters() {
        this.errors = 0;
        this.warnings = 0;
    }

    public ErrorHandler() {
        this(null);
    }

    public ErrorHandler(Writer errorWriter) {
        if (errorWriter == null) {
            errorWriter = this.makePrintWriter();
        }
        if (!(errorWriter instanceof PrintWriter)) {
            errorWriter = new PrintWriter(errorWriter, true);
        }
        this.errorWriter = (PrintWriter)errorWriter;
    }

    protected PrintWriter makePrintWriter() {
        return new PrintWriter(System.err, true);
    }

    public synchronized void internalError(Throwable uncaughtException, ASTObject where) {
        throw new InternalCompilerError(this.compiler, uncaughtException, where);
    }

    private int printLine(File source, int beginLine) {
        return this.printLines(source, beginLine, beginLine);
    }

    private static int count(String s, char ch) {
        int index = s.indexOf(ch);
        int n = 0;
        while (index != -1) {
            ++n;
            index = s.indexOf(ch, index + 1);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int printLines(File source, int beginLine, int endLine) {
        int tabCount = 0;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(source));
            try {
                int i = 1;
                while (i < beginLine) {
                    reader.readLine();
                    ++i;
                }
                while (i <= endLine) {
                    String line = reader.readLine();
                    if (line == null) {
                        this.errorWriter.println("<at end of file>");
                        int n = -1;
                        Object var10_10 = null;
                        if (reader == null) return n;
                        reader.close();
                        return n;
                    }
                    this.errorWriter.println(PREFIX + line);
                    tabCount += ErrorHandler.count(line, '\t');
                    ++i;
                }
                Object var10_11 = null;
                if (reader == null) return tabCount;
                reader.close();
                return tabCount;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
        }
        catch (IOException e) {
            this.errorWriter.println("can't read text from " + source.getPath());
        }
        return tabCount;
    }

    private void printCaretLine(int pos) {
        this.errorWriter.print(PREFIX);
        int i = 1;
        while (i < pos) {
            this.errorWriter.print(" ");
            ++i;
        }
        this.errorWriter.println("^");
    }

    public synchronized boolean showMessage(String message) {
        return this.showMessage(null, message, false, false);
    }

    public synchronized boolean showMessage(ASTObject where, String message) {
        return this.showMessage(where, message, false, false);
    }

    public synchronized boolean showMessage(File source, int line, int endLine, int column, String message, boolean isError) {
        if (isError && this.compiler.getOptionDumpStack()) {
            Thread.dumpStack();
        }
        if (source == null) {
            this.errorWriter.println(PREFIX + message);
            return true;
        }
        String head = source.getPath() + ":" + line + ":" + column + ": ";
        String firstLine = head + message;
        if (this.firstLines.contains(firstLine)) {
            return false;
        }
        this.firstLines.add(firstLine);
        this.errorWriter.println(PREFIX + firstLine);
        if (endLine > line) {
            this.printLines(source, line, endLine);
        } else {
            int tabcount = this.printLine(source, line);
            if (tabcount != -1) {
                this.printCaretLine(column += tabcount * 7);
            }
        }
        return true;
    }

    public synchronized boolean showMessage(ASTObject where, String message, boolean showAll, boolean isError) {
        ASTObject newWhere;
        if (where == null) {
            return this.showMessage(null, -1, -1, -1, message, isError);
        }
        if ((where.getSourceFile() == null || where.getBeginLine() == -1) && (newWhere = where.getSourceLocation().getSourceObject()) != null) {
            if (this.showMessage(newWhere, message, showAll, isError)) {
                if (newWhere.getBeginLine() == -1 || this.compiler.getOptions().developer) {
                    this.errorWriter.println("    in generated code: " + where.unparse());
                }
                return true;
            }
            return false;
        }
        int endLine = showAll ? where.getEndLine() : -1;
        return this.showMessage(where.getSourceFile(), where.getBeginLine(), endLine, where.getBeginColumn(), message, isError);
    }

    public synchronized void showError(ASTObject where, String message) {
        if (this.showMessage(where, message, false, true)) {
            ++this.errors;
        }
    }

    public synchronized void showError(File source, int line, int column, String message) {
        if (this.showMessage(source, line, -1, column, message, true)) {
            ++this.errors;
        }
    }

    public synchronized void showWarning(ASTObject where, String message) {
        if (this.errors > 0) {
            return;
        }
        if (this.showMessage(where, message + " (warning)")) {
            ++this.warnings;
        }
    }

    public synchronized void showWarning(ASTObject where, Message message) {
        if (message.shouldDisplay(this.getCompiler())) {
            this.showWarning(where, message.getString());
        }
    }

    public synchronized void showWarnings() {
        if (this.warnings > 0) {
            this.errorWriter.println(PREFIX + Integer.toString(this.warnings) + " warnings");
        }
    }

    public synchronized boolean willExitWithErrors() {
        return this.errors > 0;
    }

    public synchronized void exitOnErrors() {
        if (this.errors > 0) {
            this.showWarnings();
            this.errorWriter.println(PREFIX + Integer.toString(this.errors) + " errors");
            if (this.compiler.getOptionIgnoreErrors()) {
                return;
            }
            throw new CompilerErrors(this.errors);
        }
    }

    public static class Message {
        private String message;

        public Message(String message) {
            this.message = message;
        }

        public boolean shouldDisplay(JavaCompiler compiler) {
            return compiler.getOptions().Xlint;
        }

        public String getString() {
            return this.message;
        }
    }
}

