/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

class CodeText {
    protected byte[] data;
    protected int index;
    protected boolean addSlash;

    public CodeText(int expectedSize) {
        this.data = new byte[expectedSize];
        this.index = 0;
        this.addSlash = false;
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] backup(int toIndex) {
        int backupSize = this.index - toIndex;
        byte[] ret = new byte[backupSize];
        System.arraycopy(this.data, toIndex, ret, 0, backupSize);
        this.index = toIndex;
        return ret;
    }

    private final void expandTo(int newSize) {
        if (newSize < this.data.length) {
            return;
        }
        int newLength = this.data.length * 2;
        while (newLength < newSize) {
            newLength *= 2;
        }
        byte[] newData = new byte[newLength];
        System.arraycopy(this.data, 0, newData, 0, this.index);
        this.data = newData;
    }

    public void write(byte b) {
        this.expandTo(this.index + 1);
        this.data[this.index++] = b;
    }

    public void write(byte[] bytes) {
        this.expandTo(this.index + bytes.length);
        System.arraycopy(bytes, 0, this.data, this.index, bytes.length);
        this.index += bytes.length;
    }

    public void write(String s) {
        int N = s.length();
        int i = 0;
        while (i < N) {
            this.write(s.charAt(i));
            ++i;
        }
    }

    public void write(int ch) {
        this.expandTo(this.index + 7);
        if (this.addSlash && ch == 117) {
            this.data[this.index++] = 92;
        }
        this.addSlash = ch == 92 ? !this.addSlash : false;
        if (ch < 1 || ch > 126) {
            int b1 = ch >> 12;
            int b2 = ch >> 8 & 0xF;
            int b3 = ch >> 4 & 0xF;
            int b4 = ch & 0xF;
            this.data[this.index++] = 92;
            this.data[this.index++] = 117;
            this.data[this.index++] = (byte)Character.forDigit(b1, 16);
            this.data[this.index++] = (byte)Character.forDigit(b2, 16);
            this.data[this.index++] = (byte)Character.forDigit(b3, 16);
            this.data[this.index++] = (byte)Character.forDigit(b4, 16);
        } else {
            this.data[this.index++] = (byte)ch;
        }
    }

    public String getString() {
        try {
            return new String(this.data, 0, this.index, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.data, 0, this.index);
        }
    }

    public void writeTo(OutputStream ostream) throws IOException {
        ostream.write(this.data, 0, this.index);
        ostream.flush();
    }
}

