/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.HashMap;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.TypeManager;
import org.aspectj.compiler.base.WalkerPass;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ArrayType;
import org.aspectj.compiler.base.ast.ClassDec;
import org.aspectj.compiler.base.ast.ClassExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.PrimitiveType;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;

public class ClassExprPass
extends WalkerPass {
    TypeDec dec = null;
    HashMap fields = null;
    MethodDec method = null;
    TypeDec holder = null;

    public ClassExprPass(JavaCompiler jc) {
        super(jc);
    }

    public String getDisplayName() {
        return "desugaring T.class exprs";
    }

    public ASTObject process(ASTObject object) {
        if (object instanceof TypeDec) {
            TypeDec savedDec = this.dec;
            HashMap savedFields = this.fields;
            MethodDec savedMethod = this.method;
            TypeDec savedHolder = this.holder;
            this.dec = (TypeDec)object;
            this.fields = new HashMap();
            if (object instanceof ClassDec) {
                this.holder = this.dec;
            }
            object.walk(this);
            this.dec = savedDec;
            this.fields = savedFields;
            this.method = savedMethod;
            this.holder = savedHolder;
            return object;
        }
        if (object instanceof ClassExpr) {
            object = this.handleClassExpr((ClassExpr)object);
        }
        object.walk(this);
        return object;
    }

    ASTObject handleClassExpr(ClassExpr object) {
        AST ast = this.getAST();
        Type ty = object.getTypeD().getType();
        if (ty instanceof PrimitiveType) {
            return ty.getClassExpr();
        }
        FieldDec field = this.genField(ty);
        MethodDec maker = this.genMethod();
        return ast.makeTriTest(ast.makeBinop("==", ast.makeGet(field), ast.makeNull()), ast.makeSet(field, (Expr)ast.makeStaticCall(this.method, (Expr)ast.makeString(ty.getExternalName()))), ast.makeGet(field));
    }

    FieldDec genField(Type ty) {
        AST ast = this.getAST();
        TypeManager tm = this.getTypeManager();
        FieldDec field = (FieldDec)this.fields.get(ty);
        if (field == null) {
            if (this.holder == null) {
                this.genHolder();
            }
            field = ast.makeField(ast.makeModifiers(8), tm.getClassType(), this.genFieldName(ty));
            this.holder.getBody().add(field);
            this.fields.put(ty, field);
        }
        return field;
    }

    String genFieldName(Type ty) {
        String str = ty.getExternalName();
        str = ty instanceof ArrayType ? "array" + str : "class$" + str;
        if ((str = str.replace('[', '$').replace('.', '$')).charAt(str.length() - 1) == ';') {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    MethodDec genMethod() {
        AST ast = this.getAST();
        TypeManager tm = this.getTypeManager();
        if (this.method == null) {
            if (this.holder == null) {
                this.genHolder();
            }
            FormalDec formal = ast.makeFormal(tm.getStringType(), "name$");
            FormalDec exnFormal = ast.makeFormal(tm.getType("java.lang", "ClassNotFoundException"), "exn$");
            this.method = ast.makeMethod(ast.makeModifiers(8), tm.getClassType(), "class$", ast.makeFormals(formal), ast.makeCodeBody(ast.makeTryCatch(ast.makeBlock(ast.makeReturn(ast.makeStaticCall((Type)tm.getClassType(), "forName", ast.makeExprs(ast.makeVar(formal))))), exnFormal, ast.makeBlock(ast.makeThrow(ast.makeNew(tm.getType("java.lang", "NoClassDefFoundError"), ast.makeCall((Expr)ast.makeVar(exnFormal), "getMessage", ast.makeExprs())))))));
            this.holder.getBody().add(this.method);
        }
        return this.method;
    }

    void genHolder() {
        AST ast = this.getAST();
        TypeManager tm = this.getTypeManager();
        this.holder = ast.makeClass(ast.makeModifiers(10), "00", tm.getObjectType().makeTypeD(), ast.makeTypeDs());
        this.holder.setIsInner(false);
        this.dec.addMemberTypeDec(this.holder);
    }
}

