/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.associations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.asm.Association;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.Relation;
import org.aspectj.asm.RelationNode;
import org.aspectj.asm.StructureModelManager;
import org.aspectj.asm.internal.StructureNodeFactory;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.Import;
import org.aspectj.compiler.base.ast.Imports;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.PrimitiveType;
import org.aspectj.compiler.base.ast.ResolvedTypeD;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.PointcutDec;

public class Reference
implements Association {
    public static final String NAME = "Reference";
    public static final Relation USES_POINTCUT_RELATION = new Relation("uses pointcut", "pointcut used by", "Reference", true, true);
    public static final Relation IMPORTS_RELATION = new Relation("imports", "Reference", false);
    private List relations = new ArrayList();

    public Reference() {
        this.relations.add(USES_POINTCUT_RELATION);
        this.relations.add(IMPORTS_RELATION);
    }

    public List getRelations() {
        return this.relations;
    }

    public List getRelationNodes(ASTObject astObject) {
        ArrayList<RelationNode> relations = new ArrayList<RelationNode>();
        ArrayList<LinkNode> pointcutsUsed = new ArrayList<LinkNode>();
        ArrayList<LinkNode> pointcutUsedBy = new ArrayList<LinkNode>();
        ArrayList<LinkNode> throwsTypes = new ArrayList<LinkNode>();
        ArrayList<LinkNode> imports = new ArrayList<LinkNode>();
        ArrayList<LinkNode> usesType = new ArrayList<LinkNode>();
        Set forwardCorrs = StructureModelManager.correspondences.getAffects(astObject);
        Set backCorrs = StructureModelManager.correspondences.getAffectedBy(astObject);
        if (astObject instanceof AdviceDec) {
            Iterator it = forwardCorrs.iterator();
            while (it.hasNext()) {
                ASTObject node = (ASTObject)it.next();
                if (!(node instanceof PointcutDec)) continue;
                pointcutsUsed.add(StructureNodeFactory.makeLink(node, false));
            }
        } else if (astObject instanceof PointcutDec) {
            Iterator it = backCorrs.iterator();
            while (it.hasNext()) {
                ASTObject node = (ASTObject)it.next();
                if (!(node instanceof PointcutDec) && !(node instanceof AdviceDec)) continue;
                pointcutUsedBy.add(StructureNodeFactory.makeLink(node, false));
            }
            Iterator it2 = forwardCorrs.iterator();
            while (it2.hasNext()) {
                ASTObject node = (ASTObject)it2.next();
                if (!(node instanceof PointcutDec)) continue;
                pointcutsUsed.add(StructureNodeFactory.makeLink(node, false));
            }
        } else if (astObject instanceof MethodDec) {
            Method method = ((MethodDec)astObject).getMethod();
            TypeDs throwsDs = method.getThrows();
            if (throwsDs != null) {
                Iterator it = throwsDs.iterator();
                while (it.hasNext()) {
                    ResolvedTypeD resolved;
                    Object o = it.next();
                    if (!(o instanceof ResolvedTypeD) || (resolved = (ResolvedTypeD)o).getType().getCorrespondingDec() == null) continue;
                    throwsTypes.add(StructureNodeFactory.makeLink(resolved.getType().getCorrespondingDec(), false));
                }
            }
            if (!(method.getReturnType() instanceof PrimitiveType) && method.getReturnType().getCorrespondingDec() != null) {
                usesType.add(StructureNodeFactory.makeLink(method.getReturnType().getCorrespondingDec(), false));
            }
        } else if (astObject instanceof FieldDec) {
            Field field = ((FieldDec)astObject).getField();
            if (!(field.getFieldType() instanceof PrimitiveType) && field.getFieldType().getCorrespondingDec() != null) {
                usesType.add(StructureNodeFactory.makeLink(field.getFieldType().getCorrespondingDec(), false));
            }
        } else if (astObject instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)astObject;
            Imports cuImports = cu.getImports();
            int i = 0;
            while (cuImports != null && i < cuImports.getChildCount()) {
                Type type;
                Dec dec;
                Import imp = cuImports.get(i);
                if (!imp.getStar() && imp != null && imp.getType() != null && (dec = (type = imp.getType()).getCorrespondingDec()) != null) {
                    imports.add(StructureNodeFactory.makeLink(dec, true));
                }
                ++i;
            }
        }
        if (!pointcutsUsed.isEmpty()) {
            relations.add(new RelationNode(USES_POINTCUT_RELATION, USES_POINTCUT_RELATION.getForwardNavigationName(), pointcutsUsed));
        }
        if (!pointcutUsedBy.isEmpty()) {
            relations.add(new RelationNode(USES_POINTCUT_RELATION, USES_POINTCUT_RELATION.getBackNavigationName(), pointcutUsedBy));
        }
        if (!imports.isEmpty()) {
            relations.add(new RelationNode(IMPORTS_RELATION, IMPORTS_RELATION.getForwardNavigationName(), imports));
        }
        return relations;
    }

    public String getName() {
        return NAME;
    }
}

