/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.associations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.asm.Association;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.Relation;
import org.aspectj.asm.RelationNode;
import org.aspectj.asm.StructureModelManager;
import org.aspectj.asm.internal.StructureNodeFactory;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.ast.IntroducedDec;

public class Introduction
implements Association {
    public static final String NAME = "Introduction";
    public static final Relation INTRODUCES_RELATION = new Relation("declares member on", "inter-type declared members", "Introduction", true, false);
    private List relations = new ArrayList();

    public Introduction() {
        this.relations.add(INTRODUCES_RELATION);
    }

    public List getRelations() {
        return this.relations;
    }

    public List getRelationNodes(ASTObject astObject) {
        ArrayList<RelationNode> relations = new ArrayList<RelationNode>();
        ArrayList<LinkNode> introduces = new ArrayList<LinkNode>();
        Set forwardCorrs = StructureModelManager.correspondences.getAffects(astObject);
        Set backCorrs = StructureModelManager.correspondences.getAffectedBy(astObject);
        if (astObject instanceof IntroducedDec) {
            Iterator it = forwardCorrs.iterator();
            while (it.hasNext()) {
                ASTObject node = (ASTObject)it.next();
                LinkNode link = StructureNodeFactory.makeLink(node, false);
                if (!(node instanceof TypeDec)) continue;
                introduces.add(link);
            }
            if (!introduces.isEmpty()) {
                relations.add(new RelationNode(INTRODUCES_RELATION, INTRODUCES_RELATION.getForwardNavigationName(), introduces));
            }
        } else {
            Iterator it = backCorrs.iterator();
            while (it.hasNext()) {
                ASTObject node = (ASTObject)it.next();
                if (!(astObject instanceof TypeDec) || !(node instanceof IntroducedDec)) continue;
                introduces.add(StructureNodeFactory.makeLink(node, false));
            }
            if (!introduces.isEmpty()) {
                relations.add(new RelationNode(INTRODUCES_RELATION, INTRODUCES_RELATION.getBackNavigationName(), introduces));
            }
        }
        return relations;
    }

    public String getName() {
        return NAME;
    }
}

