/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.Association;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.Relation;
import org.aspectj.asm.RelationNode;
import org.aspectj.asm.internal.StructureNodeFactory;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.TypeDec;

public class Inheritance
implements Association {
    public static final String NAME = "Inheritance";
    public static final Relation INHERITS_RELATION = new Relation("inherits", "is inherited by", "Inheritance", true, true);
    public static final Relation IMPLEMENTS_RELATION = new Relation("implements", "is implemented by", "Inheritance", true, true);
    public static final Relation INHERITS_MEMBERS_RELATION = new Relation("inherits members", "Inheritance", false);
    private List relations = new ArrayList();

    public Inheritance() {
        this.relations.add(INHERITS_RELATION);
        this.relations.add(IMPLEMENTS_RELATION);
        this.relations.add(INHERITS_MEMBERS_RELATION);
    }

    public List getRelations() {
        return this.relations;
    }

    public List getRelationNodes(ASTObject astObject) {
        ArrayList<RelationNode> relations = new ArrayList<RelationNode>();
        if (astObject instanceof TypeDec) {
            ArrayList inheritedMembers;
            TypeDec typeDec = (TypeDec)astObject;
            boolean isInterface = astObject instanceof InterfaceDec;
            List superTypes = this.getTypeLinks(typeDec.getType().getDirectSuperTypes(), true, isInterface);
            List subTypes = this.getTypeLinks(typeDec.getType().getDirectSubTypes(), true, isInterface);
            if (!superTypes.isEmpty()) {
                relations.add(new RelationNode(INHERITS_RELATION, INHERITS_RELATION.getForwardNavigationName(), superTypes));
            }
            if (!subTypes.isEmpty()) {
                relations.add(new RelationNode(INHERITS_RELATION, INHERITS_RELATION.getBackNavigationName(), subTypes));
            }
            List implementedInterfaces = this.getTypeLinks(typeDec.getType().getDirectSuperTypes(), false, isInterface);
            List implementors = this.getTypeLinks(typeDec.getType().getDirectSubTypes(), false, isInterface);
            if (!implementedInterfaces.isEmpty()) {
                relations.add(new RelationNode(IMPLEMENTS_RELATION, IMPLEMENTS_RELATION.getForwardNavigationName(), implementedInterfaces));
            }
            if (!implementors.isEmpty()) {
                relations.add(new RelationNode(IMPLEMENTS_RELATION, IMPLEMENTS_RELATION.getBackNavigationName(), implementors));
            }
            if (!(inheritedMembers = new ArrayList(this.getMemberLinks(typeDec.getType().getInheritedMethods()))).isEmpty()) {
                relations.add(new RelationNode(INHERITS_MEMBERS_RELATION, INHERITS_MEMBERS_RELATION.getForwardNavigationName(), inheritedMembers));
            }
        }
        return relations;
    }

    private List getTypeLinks(Collection types, boolean isInheritance, boolean isInterface) {
        ArrayList<LinkNode> links = new ArrayList<LinkNode>();
        if (types != null) {
            Iterator it = types.iterator();
            while (it.hasNext()) {
                NameType nameType = (NameType)it.next();
                if (nameType.getId().equals("Object") || !(isInheritance && (isInterface && nameType.isInterface() || !isInterface && !nameType.isInterface())) && (isInheritance || isInterface || !nameType.isInterface())) continue;
                Dec dec = nameType.getCorrespondingDec();
                links.add(StructureNodeFactory.makeLink(dec, false));
            }
        }
        return links;
    }

    private List getMemberLinks(Collection members) {
        ArrayList<LinkNode> links = new ArrayList<LinkNode>();
        if (members != null) {
            Iterator it = members.iterator();
            while (it.hasNext()) {
                Field field;
                Object object = it.next();
                if (object instanceof Method) {
                    Method method = (Method)object;
                    if (method.getDeclaringType().getId().equals("Object")) continue;
                    links.add(StructureNodeFactory.makeLink(method.getCorrespondingDec(), false));
                    continue;
                }
                if (!(object instanceof Field) || (field = (Field)object).getDeclaringType().getId().equals("Object")) continue;
                links.add(StructureNodeFactory.makeLink(field.getCorrespondingDec(), false));
            }
        }
        return links;
    }

    public String getName() {
        return NAME;
    }
}

