/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.ModelWalker;
import org.aspectj.asm.SourceLocation;
import org.aspectj.asm.StructureMessage;

public abstract class StructureNode
implements Serializable,
Comparable {
    protected StructureNode parent = null;
    protected String name = "";
    protected String kind = "";
    protected List children = new ArrayList();
    protected StructureMessage message = null;
    protected SourceLocation sourceLocation = null;

    public StructureNode() {
    }

    public StructureNode(String name, String kind, List children) {
        this.name = name;
        this.kind = kind;
        if (children != null) {
            this.children = children;
        }
        this.setParents();
    }

    public StructureNode(String name, String kind) {
        this.name = name;
        this.kind = kind;
    }

    public String toString() {
        return this.name;
    }

    public String getKind() {
        return this.kind;
    }

    public List getChildren() {
        return this.children;
    }

    public void addChild(StructureNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public boolean removeChild(StructureNode child) {
        child.setParent(null);
        return this.children.remove(child);
    }

    public StructureNode walk(ModelWalker walker) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            StructureNode child = (StructureNode)it.next();
            walker.process(child);
        }
        return this;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        StructureNode sn = (StructureNode)o;
        return this.getName().compareTo(sn.getName());
    }

    public String getName() {
        return this.name;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(SourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public StructureMessage getMessage() {
        return this.message;
    }

    public void setMessage(StructureMessage message) {
        this.message = message;
    }

    public StructureNode getParent() {
        return this.parent;
    }

    public void setParent(StructureNode parent) {
        this.parent = parent;
    }

    private void setParents() {
        if (this.children == null) {
            return;
        }
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            ((StructureNode)it.next()).setParent(this);
        }
    }
}

