/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm;

import java.io.File;
import java.io.Serializable;

public class SourceLocation
implements Serializable {
    private String sourceFilePath = null;
    private String sourceFileName = null;
    private int lineNumber = -1;
    private int endLineNumber = -1;
    private int columnNumber = 0;

    public SourceLocation(String sourceFilePath, int lineNumber, int columnNumber) {
        this(sourceFilePath, lineNumber, lineNumber, columnNumber);
    }

    public SourceLocation(String sourceFilePath, int beginLineNumber, int endLineNumber, int beginColumnNumber) {
        if (sourceFilePath != null) {
            this.sourceFilePath = sourceFilePath.replace('\\', '/');
        }
        this.lineNumber = beginLineNumber;
        this.endLineNumber = endLineNumber;
        this.columnNumber = beginColumnNumber;
        if (sourceFilePath != null) {
            this.sourceFileName = new File(sourceFilePath).getName();
        }
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getEndLineNumber() {
        return this.endLineNumber;
    }

    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String toString() {
        return this.sourceFilePath + ", begin line: " + this.lineNumber + ", end line:" + this.endLineNumber;
    }
}

