/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.AbstractIcon;
import org.aspectj.ajde.ui.GlobalStructureView;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.swing.StructureTree;
import org.aspectj.ajde.ui.swing.StructureViewTreeListener;
import org.aspectj.ajde.ui.swing.SwingTreeViewNode;
import org.aspectj.ajde.ui.swing.SwingTreeViewNodeRenderer;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.RelationNode;
import org.aspectj.asm.StructureModel;
import org.aspectj.asm.StructureNode;

class StructureTreeManager {
    private StructureTree structureTree;
    private SwingTreeViewNodeRenderer cellRenderer = null;
    private TreeSelectionListener treeListener = null;
    private final StructureTreeModel NO_STRUCTURE_MODEL = new StructureTreeModel(new SwingTreeViewNode(StructureModel.NO_STRUCTURE, new AbstractIcon(null), new ArrayList()));

    public StructureTreeManager() {
        this.structureTree = new StructureTree();
        this.structureTree.setModel(this.NO_STRUCTURE_MODEL);
        this.cellRenderer = new SwingTreeViewNodeRenderer();
        this.structureTree.setCellRenderer(this.cellRenderer);
        this.treeListener = new StructureViewTreeListener(this.structureTree);
        this.structureTree.addTreeSelectionListener(this.treeListener);
        this.structureTree.addMouseListener((MouseListener)((Object)this.treeListener));
    }

    public void highlightNode(ProgramElementNode node) {
        this.highlightNode((SwingTreeViewNode)this.structureTree.getModel().getRoot(), node);
    }

    public StructureNode getSelectedStructureNode() {
        return (StructureNode)((SwingTreeViewNode)this.structureTree.getLastSelectedPathComponent()).getUserObject();
    }

    public void scrollToHighlightedNode() {
        this.structureTree.scrollPathToVisible(this.structureTree.getSelectionPath());
    }

    private void highlightNode(SwingTreeViewNode parent, ProgramElementNode node) {
        int i = 0;
        while (i < parent.getChildCount()) {
            SwingTreeViewNode currNode = (SwingTreeViewNode)parent.getChildAt(i);
            StructureNode sNode = (StructureNode)currNode.getUserObject();
            if (sNode instanceof ProgramElementNode && ((ProgramElementNode)sNode).equals(node)) {
                TreePath path = new TreePath(currNode.getPath());
                this.structureTree.setSelectionPath(path);
                int currRow = this.structureTree.getRowForPath(path);
                this.structureTree.expandRow(currRow);
                this.structureTree.scrollRowToVisible(currRow);
            } else {
                this.highlightNode(currNode, node);
            }
            ++i;
        }
    }

    public void updateTree(final StructureView structureView) {
        if (structureView == null) {
            return;
        }
        Runnable update = new Runnable(){

            public void run() {
                StructureTreeManager.this.structureTree.removeAll();
                if (structureView.getRootNode() == null) {
                    StructureTreeManager.this.structureTree.setModel(StructureTreeManager.this.NO_STRUCTURE_MODEL);
                } else {
                    StructureTreeManager.this.structureTree.setModel(new StructureTreeModel((SwingTreeViewNode)structureView.getRootNode()));
                }
                if (structureView instanceof GlobalStructureView) {
                    GlobalStructureView view = (GlobalStructureView)structureView;
                    if (view.getGlobalViewProperties().getHierarchy() == StructureViewProperties.Hierarchy.DECLARATION) {
                        StructureTreeManager.this.expandTreeToFiles();
                    } else {
                        StructureTreeManager.this.expandTree(15);
                    }
                } else {
                    StructureTreeManager.this.expandTree(10);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            update.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(update);
            }
            catch (Exception e) {
                Ajde.getDefault().getErrorHandler().handleError("Could not update tree.", e);
            }
        }
    }

    StructureTree getStructureTree() {
        return this.structureTree;
    }

    private void expandTreeToFiles() {
        int i = 0;
        while (i < this.structureTree.getRowCount()) {
            TreePath path = this.structureTree.getPathForRow(i);
            SwingTreeViewNode node = (SwingTreeViewNode)path.getLastPathComponent();
            if (node.getUserObject() instanceof ProgramElementNode) {
                ProgramElementNode pNode = (ProgramElementNode)node.getUserObject();
                ProgramElementNode.Kind kind = pNode.getProgramElementKind();
                if (kind == ProgramElementNode.Kind.PROJECT || kind == ProgramElementNode.Kind.PACKAGE) {
                    this.structureTree.expandPath(path);
                } else {
                    this.structureTree.collapsePath(path);
                }
            } else {
                this.structureTree.collapsePath(path);
            }
            ++i;
        }
        this.structureTree.expandPath(this.structureTree.getPathForRow(0));
    }

    private void expandTree(int depth) {
        int i = 0;
        while (i < this.structureTree.getRowCount()) {
            TreePath path = this.structureTree.getPathForRow(i);
            SwingTreeViewNode node = (SwingTreeViewNode)path.getLastPathComponent();
            if (path.getPath().length - 1 > depth || node.getUserObject() instanceof RelationNode) {
                this.structureTree.collapsePath(path);
            } else {
                this.structureTree.expandPath(path);
            }
            ++i;
        }
        this.structureTree.expandPath(this.structureTree.getPathForRow(0));
    }

    private class StructureTreeModel
    extends DefaultTreeModel
    implements TreeModel {
        public StructureTreeModel(TreeNode newRoot) {
            super(newRoot);
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.nodeChanged(node);
        }
    }
}

