/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.GlobalStructureView;
import org.aspectj.ajde.ui.GlobalViewProperties;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.swing.AjdeUIManager;
import org.aspectj.ajde.ui.swing.IconRegistry;
import org.aspectj.ajde.ui.swing.PointcutWizard;
import org.aspectj.ajde.ui.swing.StructureViewPanel;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.StructureNode;
import org.aspectj.asm.associations.Advice;
import org.aspectj.asm.associations.Inheritance;

public class BrowserViewManager {
    private StructureViewPanel browserPanel = null;
    private boolean globalMode = true;
    private boolean splitViewMode = false;
    private IconRegistry icons;
    private Stack backHistory = new Stack();
    private Stack forwardHistory = new Stack();
    private ProgramElementNode currNode = null;
    private final GlobalStructureView DECLARATION_VIEW;
    private final GlobalStructureView CROSSCUTTING_VIEW;
    private final GlobalStructureView INHERITANCE_VIEW;
    private final GlobalViewProperties DECLARATION_VIEW_PROPERTIES = new GlobalViewProperties(StructureViewProperties.Hierarchy.DECLARATION);
    private final GlobalViewProperties CROSSCUTTING_VIEW_PROPERTIES = new GlobalViewProperties(StructureViewProperties.Hierarchy.CROSSCUTTING);
    private final GlobalViewProperties INHERITANCE_VIEW_PROPERTIES = new GlobalViewProperties(StructureViewProperties.Hierarchy.INHERITANCE);

    public BrowserViewManager() {
        this.CROSSCUTTING_VIEW_PROPERTIES.addRelation(Advice.METHOD_RELATION);
        this.CROSSCUTTING_VIEW_PROPERTIES.addRelation(Advice.METHOD_CALL_SITE_RELATION);
        this.CROSSCUTTING_VIEW_PROPERTIES.addRelation(Advice.CONSTRUCTOR_RELATION);
        this.CROSSCUTTING_VIEW_PROPERTIES.addRelation(Advice.CONSTRUCTOR_CALL_SITE_RELATION);
        this.CROSSCUTTING_VIEW_PROPERTIES.addRelation(Advice.HANDLER_RELATION);
        this.CROSSCUTTING_VIEW_PROPERTIES.addRelation(Advice.INITIALIZER_RELATION);
        this.CROSSCUTTING_VIEW_PROPERTIES.addRelation(Advice.FIELD_ACCESS_RELATION);
        this.INHERITANCE_VIEW_PROPERTIES.addRelation(Inheritance.IMPLEMENTS_RELATION);
        this.INHERITANCE_VIEW_PROPERTIES.addRelation(Inheritance.INHERITS_MEMBERS_RELATION);
        this.INHERITANCE_VIEW_PROPERTIES.addRelation(Inheritance.INHERITS_RELATION);
        this.DECLARATION_VIEW_PROPERTIES.setRelations(Ajde.getDefault().getStructureViewManager().getAvailableRelations());
        this.CROSSCUTTING_VIEW = Ajde.getDefault().getStructureViewManager().createGlobalView(this.CROSSCUTTING_VIEW_PROPERTIES);
        this.INHERITANCE_VIEW = Ajde.getDefault().getStructureViewManager().createGlobalView(this.INHERITANCE_VIEW_PROPERTIES);
        this.DECLARATION_VIEW = Ajde.getDefault().getStructureViewManager().createGlobalView(this.DECLARATION_VIEW_PROPERTIES);
        ArrayList<GlobalStructureView> views = new ArrayList<GlobalStructureView>();
        views.add(this.DECLARATION_VIEW);
        views.add(this.CROSSCUTTING_VIEW);
        views.add(this.INHERITANCE_VIEW);
        this.browserPanel = new StructureViewPanel(views);
    }

    public StructureViewPanel getBrowserPanel() {
        return this.browserPanel;
    }

    public void showSourcesNodes(List nodes) {
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            ProgramElementNode currNode = null;
            StructureNode structureNode = (StructureNode)it.next();
            currNode = structureNode instanceof LinkNode ? ((LinkNode)structureNode).getProgramElementNode() : (ProgramElementNode)structureNode;
            Ajde.getDefault().getEditorManager().addViewForSourceLine(currNode.getSourceLocation().getSourceFilePath(), currNode.getSourceLocation().getLineNumber());
        }
    }

    public void extractAndInsertSignatures(List signatures, boolean calls) {
        PointcutWizard pointcutWizard = new PointcutWizard(signatures);
        ((Component)pointcutWizard).setVisible(true);
        ((Component)pointcutWizard).setLocation(AjdeUIManager.getDefault().getRootFrame().getX() + 100, AjdeUIManager.getDefault().getRootFrame().getY() + 100);
    }
}

