/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.FileStructureView;
import org.aspectj.ajde.ui.GlobalStructureView;
import org.aspectj.ajde.ui.GlobalViewProperties;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewNode;
import org.aspectj.ajde.ui.StructureViewNodeFactory;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.internal.NavigationHistoryModel;
import org.aspectj.ajde.ui.internal.TreeStructureViewBuilder;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.StructureModel;
import org.aspectj.asm.StructureModelListener;
import org.aspectj.asm.StructureModelManager;
import org.aspectj.asm.StructureNode;
import org.aspectj.asm.associations.Advice;
import org.aspectj.asm.associations.Inheritance;
import org.aspectj.asm.associations.Introduction;
import org.aspectj.asm.associations.Reference;

public class StructureViewManager {
    private TreeStructureViewBuilder treeViewBuilder;
    private String buildConfigFilePath = null;
    private NavigationHistoryModel historyModel = new NavigationHistoryModel();
    private ArrayList structureViews = new ArrayList();
    private FileStructureView defaultFileView = null;
    private static final StructureViewProperties DEFAULT_VIEW_PROPERTIES;
    private static final List AVAILABLE_RELATIONS;
    public final StructureModelListener VIEW_LISTENER = new StructureModelListener(){

        public void modelUpdated(StructureModel model) {
            Ajde.getDefault().logEvent("updating structure views: " + StructureViewManager.this.structureViews);
            if (StructureViewManager.this.defaultFileView != null) {
                StructureViewManager.this.defaultFileView.setSourceFile(Ajde.getDefault().getEditorManager().getCurrFile());
            }
            Iterator it = ((AbstractList)StructureViewManager.this.structureViews).iterator();
            while (it.hasNext()) {
                StructureViewManager.this.treeViewBuilder.buildView((StructureView)it.next(), model);
            }
        }
    };

    public StructureViewManager(StructureViewNodeFactory nodeFactory) {
        this.treeViewBuilder = new TreeStructureViewBuilder(nodeFactory);
        StructureModelManager.INSTANCE.addListener(this.VIEW_LISTENER);
    }

    public void fireNavigateBackAction(StructureView view) {
        ProgramElementNode backNode = this.historyModel.navigateBack();
        if (backNode == null) {
            Ajde.getDefault().getIdeUIAdapter().displayStatusInformation("No node to navigate back to in history");
        } else {
            this.navigationAction(backNode, false);
        }
    }

    public void fireNavigateForwardAction(StructureView view) {
        ProgramElementNode forwardNode = this.historyModel.navigateForward();
        if (forwardNode == null) {
            Ajde.getDefault().getIdeUIAdapter().displayStatusInformation("No node to navigate forward to in history");
        } else {
            this.navigationAction(forwardNode, false);
        }
    }

    public void fireNavigationAction(String newFilePath, int lineNumber) {
        StructureNode currNode = Ajde.getDefault().getStructureModelManager().getStructureModel().findNodeForSourceLine(newFilePath, lineNumber);
        if (currNode instanceof ProgramElementNode) {
            this.navigationAction((ProgramElementNode)currNode, true);
        }
    }

    public void fireNavigationAction(StructureNode structureNode) {
        ProgramElementNode node = null;
        boolean recordHistory = false;
        if (structureNode instanceof LinkNode) {
            node = ((LinkNode)structureNode).getProgramElementNode();
            recordHistory = true;
        } else if (structureNode instanceof ProgramElementNode) {
            node = (ProgramElementNode)structureNode;
        }
        if (node != null) {
            this.navigationAction(node, recordHistory);
        }
    }

    private void navigationAction(ProgramElementNode node, boolean recordHistory) {
        block9: {
            block8: {
                if (node == null) break block8;
                Ajde.getDefault().getStructureModelManager().getStructureModel();
                if (node != StructureModel.NO_STRUCTURE && node.getSourceLocation().getSourceFilePath() != null) break block9;
            }
            Ajde.getDefault().getIdeUIAdapter().displayStatusInformation("Source not available for node: " + node.getName());
            return;
        }
        Ajde.getDefault().logEvent("navigating to node: " + node + ", recordHistory: " + recordHistory);
        if (recordHistory) {
            this.historyModel.navigateToNode(node);
        }
        if (this.defaultFileView != null && node.getSourceLocation() != null) {
            String newFilePath = node.getSourceLocation().getSourceFilePath();
            if (this.defaultFileView.getSourceFile() != null && !this.defaultFileView.getSourceFile().equals(newFilePath)) {
                this.defaultFileView.setSourceFile(newFilePath);
                this.treeViewBuilder.buildView(this.defaultFileView, StructureModelManager.INSTANCE.getStructureModel());
            }
        }
        Iterator it = ((AbstractList)this.structureViews).iterator();
        while (it.hasNext()) {
            StructureView view = (StructureView)it.next();
            if (view instanceof GlobalStructureView && recordHistory && this.defaultFileView != null) continue;
            if (node.getProgramElementKind().equals(ProgramElementNode.Kind.CODE)) {
                ProgramElementNode parentNode = (ProgramElementNode)node.getParent();
                if (parentNode == null) continue;
                StructureViewNode currNode = view.findCorrespondingViewNode(parentNode);
                int lineOffset = node.getSourceLocation().getLineNumber() - parentNode.getSourceLocation().getLineNumber();
                if (currNode == null) continue;
                view.setActiveNode(currNode, lineOffset);
                continue;
            }
            StructureViewNode currNode = view.findCorrespondingViewNode(node);
            if (currNode == null) continue;
            view.setActiveNode(currNode);
        }
    }

    private ProgramElementNode getProgramElementNode(StructureViewNode node) {
        if (node.getStructureNode() instanceof ProgramElementNode) {
            return (ProgramElementNode)node.getStructureNode();
        }
        if (node.getStructureNode() instanceof LinkNode) {
            return ((LinkNode)node.getStructureNode()).getProgramElementNode();
        }
        return null;
    }

    public void refreshView(StructureView view) {
        StructureViewNode activeNode = view.getActiveNode();
        this.treeViewBuilder.buildView(view, Ajde.getDefault().getStructureModelManager().getStructureModel());
        view.setActiveNode(activeNode);
    }

    public StructureViewProperties getDefaultViewProperties() {
        return DEFAULT_VIEW_PROPERTIES;
    }

    public List getAvailableRelations() {
        return AVAILABLE_RELATIONS;
    }

    public GlobalStructureView createGlobalView(GlobalViewProperties properties) {
        GlobalStructureView view = new GlobalStructureView(properties);
        this.structureViews.add(view);
        return view;
    }

    public FileStructureView createViewForSourceFile(String sourceFilePath, StructureViewProperties properties) {
        Ajde.getDefault().logEvent("creating view for file: " + sourceFilePath);
        if (properties == null) {
            properties = DEFAULT_VIEW_PROPERTIES;
        }
        FileStructureView view = new FileStructureView(properties);
        view.setSourceFile(sourceFilePath);
        this.treeViewBuilder.buildView(view, StructureModelManager.INSTANCE.getStructureModel());
        this.structureViews.add(view);
        return view;
    }

    public boolean deleteView(StructureView view) {
        return ((AbstractCollection)this.structureViews).remove(view);
    }

    public void setDefaultFileView(FileStructureView defaultFileView) {
        this.defaultFileView = defaultFileView;
    }

    static {
        AVAILABLE_RELATIONS = new ArrayList();
        AVAILABLE_RELATIONS.add(Advice.METHOD_CALL_SITE_RELATION);
        AVAILABLE_RELATIONS.add(Advice.METHOD_RELATION);
        AVAILABLE_RELATIONS.add(Advice.CONSTRUCTOR_CALL_SITE_RELATION);
        AVAILABLE_RELATIONS.add(Advice.CONSTRUCTOR_RELATION);
        AVAILABLE_RELATIONS.add(Advice.FIELD_ACCESS_RELATION);
        AVAILABLE_RELATIONS.add(Advice.INITIALIZER_RELATION);
        AVAILABLE_RELATIONS.add(Advice.HANDLER_RELATION);
        AVAILABLE_RELATIONS.add(Advice.INTRODUCTION_RELATION);
        AVAILABLE_RELATIONS.add(Introduction.INTRODUCES_RELATION);
        AVAILABLE_RELATIONS.add(Inheritance.IMPLEMENTS_RELATION);
        AVAILABLE_RELATIONS.add(Inheritance.INHERITS_RELATION);
        AVAILABLE_RELATIONS.add(Inheritance.INHERITS_MEMBERS_RELATION);
        AVAILABLE_RELATIONS.add(Reference.USES_POINTCUT_RELATION);
        AVAILABLE_RELATIONS.add(Reference.IMPORTS_RELATION);
        DEFAULT_VIEW_PROPERTIES = new StructureViewProperties();
        DEFAULT_VIEW_PROPERTIES.setRelations(AVAILABLE_RELATIONS);
    }
}

