/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.internal;

import java.io.File;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.internal.AjdeCompiler;
import org.aspectj.asm.SourceLocation;
import org.aspectj.asm.StructureMessage;
import org.aspectj.asm.StructureNode;
import org.aspectj.compiler.base.CompilerErrors;
import org.aspectj.compiler.base.ErrorHandler;
import org.aspectj.compiler.base.ast.ASTObject;

public class AjdeBuildErrorHandler
extends ErrorHandler {
    protected AjdeCompiler compiler;
    protected TaskListManager taskListManager;
    protected int errors = 0;
    protected int warnings = 0;

    public void cleanupErrorWarningCounters() {
        this.errors = 0;
        this.warnings = 0;
    }

    public AjdeBuildErrorHandler(TaskListManager taskListManager) {
        this.taskListManager = taskListManager;
    }

    public synchronized boolean showMessage(String message) {
        return this.showMessage(null, message, false, false);
    }

    public synchronized boolean showMessage(ASTObject where, String message) {
        return this.showMessage(where, message, false, false);
    }

    public synchronized boolean showMessage(File source, int line, int endLine, int column, String message, boolean isError) {
        return this.addMessage(source, line, column, message, isError);
    }

    public synchronized boolean showMessage(ASTObject where, String message, boolean showAll, boolean isError) {
        ASTObject newWhere;
        if (where == null) {
            return this.showMessage(null, -1, -1, -1, message, isError);
        }
        if ((where.getSourceFile() == null || where.getBeginLine() == -1) && (newWhere = where.getSourceLocation().getSourceObject()) != null) {
            return this.showMessage(newWhere, message, showAll, isError);
        }
        return this.addMessage(where.getSourceFile(), where.getBeginLine(), where.getBeginColumn(), message, isError);
    }

    public synchronized void showError(ASTObject where, String message) {
        if (this.showMessage(where, message, false, true)) {
            ++this.errors;
        }
    }

    public synchronized void showError(File source, int line, int column, String message) {
        if (this.showMessage(source, line, -1, column, message, true)) {
            ++this.errors;
        }
    }

    public synchronized void showWarning(ASTObject where, String message) {
        if (this.errors > 0) {
            return;
        }
        if (this.showMessage(where, message, false, false)) {
            ++this.warnings;
        }
    }

    public synchronized void showWarning(ASTObject where, ErrorHandler.Message message) {
        if (this.compiler.getOptions().Xlint) {
            this.showWarning(where, message.getString());
        }
    }

    protected boolean addMessage(File source, int line, int column, String message, boolean isError) {
        if (this.taskListManager == null) {
            return false;
        }
        StructureMessage.Kind kind = isError ? StructureMessage.Kind.ERROR : StructureMessage.Kind.WARNING;
        if (source != null) {
            this.taskListManager.addSourcelineTask(message, new SourceLocation(source.getPath(), line, column), kind);
            StructureNode node = Ajde.getDefault().getStructureModelManager().getStructureModel().findNodeForSourceLine(source.getPath(), line);
            if (node != null) {
                node.setMessage(new StructureMessage(message, kind));
            }
        } else {
            this.taskListManager.addProjectTask(message, kind);
        }
        return true;
    }

    public synchronized boolean willExitWithErrors() {
        return this.errors > 0;
    }

    public synchronized void exitOnErrors() {
        if (this.errors > 0) {
            this.showWarnings();
            throw new CompilerErrors(this.errors);
        }
    }

    public int getErrorCount() {
        return this.errors;
    }

    public int getWarningCount() {
        return this.warnings;
    }

    public void setCompiler(AjdeCompiler compiler) {
        this.compiler = compiler;
    }
}

