/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde;

import java.io.PrintStream;
import java.util.List;
import org.aspectj.ajde.BuildConfigListener;
import org.aspectj.ajde.BuildConfigManager;
import org.aspectj.ajde.BuildListener;
import org.aspectj.ajde.BuildManager;
import org.aspectj.ajde.BuildOptionsAdapter;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.EditorAdapter;
import org.aspectj.ajde.ErrorHandler;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.internal.AspectJBuildManager;
import org.aspectj.ajde.internal.LstBuildConfigManager;
import org.aspectj.ajde.ui.EditorManager;
import org.aspectj.ajde.ui.IdeUIAdapter;
import org.aspectj.ajde.ui.StructureSearchManager;
import org.aspectj.ajde.ui.StructureViewManager;
import org.aspectj.ajde.ui.StructureViewNodeFactory;
import org.aspectj.asm.StructureModelManager;

public class Ajde {
    private static final Ajde INSTANCE = new Ajde();
    private static final String NOT_INITIALIZED_MESSAGE = "Ajde is not initialized.";
    private static boolean isInitialized = false;
    private BuildManager buildManager;
    private EditorManager editorManager;
    private StructureViewManager structureViewManager;
    private StructureSearchManager structureSearchManager;
    private BuildConfigManager configurationManager;
    private ProjectPropertiesAdapter projectProperties;
    private TaskListManager taskListManager;
    private IdeUIAdapter ideUIAdapter;
    private ErrorHandler errorHandler;
    private PrintStream logPrintStream = null;
    private final BuildConfigListener STRUCTURE_UPDATE_CONFIG_LISTENER = new BuildConfigListener(){

        public void currConfigChanged(String configFilePath) {
            if (configFilePath != null) {
                Ajde.getDefault().getStructureModelManager().readStructureModel(configFilePath);
            }
        }

        public void configsListUpdated(List configsList) {
        }
    };
    private final BuildListener BUILD_STATUS_LISTENER = new BuildListener(){

        public void compileStarted(String buildConfig) {
            String configFilePath = Ajde.this.projectProperties.getDefaultBuildConfigFile();
            if (buildConfig.equals(configFilePath)) {
                Ajde.this.configurationManager.writePaths(configFilePath, Ajde.this.projectProperties.getProjectSourceFiles());
                Ajde.this.logEvent("wrote default build config: " + configFilePath);
            }
        }

        public void compileFinished(String buildConfig, int buildTime, boolean succeeded, boolean warnings) {
            String configFilePath = Ajde.this.projectProperties.getDefaultBuildConfigFile();
            if (!succeeded) {
                StructureModelManager.INSTANCE.fireModelUpdated();
            }
        }

        public void compileAborted(String buildConfigFile, String message) {
        }
    };

    protected Ajde() {
        this.configurationManager = new LstBuildConfigManager();
    }

    public static void init(EditorAdapter editorAdapter, TaskListManager taskListManager, BuildProgressMonitor compileProgressMonitor, ProjectPropertiesAdapter projectProperties, BuildOptionsAdapter buildOptionsAdapter, StructureViewNodeFactory structureViewNodeFactory, IdeUIAdapter ideUIAdapter, ErrorHandler errorHandler) {
        try {
            Ajde.INSTANCE.projectProperties = projectProperties;
            Ajde.INSTANCE.errorHandler = errorHandler;
            Ajde.INSTANCE.taskListManager = taskListManager;
            Ajde.INSTANCE.editorManager = new EditorManager(editorAdapter);
            Ajde.INSTANCE.buildManager = new AspectJBuildManager(taskListManager, compileProgressMonitor, buildOptionsAdapter);
            Ajde.INSTANCE.buildManager.addListener(Ajde.INSTANCE.BUILD_STATUS_LISTENER);
            Ajde.INSTANCE.configurationManager.addListener(Ajde.INSTANCE.STRUCTURE_UPDATE_CONFIG_LISTENER);
            Ajde.INSTANCE.ideUIAdapter = ideUIAdapter;
            Ajde.INSTANCE.structureSearchManager = new StructureSearchManager();
            Ajde.INSTANCE.structureViewManager = new StructureViewManager(structureViewNodeFactory);
            isInitialized = true;
        }
        catch (Throwable t) {
            System.err.println("AJDE ERROR: could not initialize Ajde.");
            t.printStackTrace();
        }
    }

    public static Ajde getDefault() {
        if (!isInitialized) {
            throw new RuntimeException(NOT_INITIALIZED_MESSAGE);
        }
        return INSTANCE;
    }

    public void setConfigurationManager(BuildConfigManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public BuildManager getBuildManager() {
        return this.buildManager;
    }

    public EditorManager getEditorManager() {
        return this.editorManager;
    }

    public StructureViewManager getStructureViewManager() {
        return this.structureViewManager;
    }

    public StructureSearchManager getStructureSearchManager() {
        return this.structureSearchManager;
    }

    public BuildConfigManager getConfigurationManager() {
        return this.configurationManager;
    }

    public ProjectPropertiesAdapter getProjectProperties() {
        return this.projectProperties;
    }

    public TaskListManager getTaskListManager() {
        return this.taskListManager;
    }

    public IdeUIAdapter getIdeUIAdapter() {
        return this.ideUIAdapter;
    }

    public void setIdeUIAdapter(IdeUIAdapter ideUIAdapter) {
        this.ideUIAdapter = ideUIAdapter;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public String getVersion() {
        return "1.0.6";
    }

    public void enableLogging(PrintStream logPrintStream) {
        this.logPrintStream = logPrintStream;
    }

    public void disableLogging() {
        this.logPrintStream = null;
    }

    public StructureModelManager getStructureModelManager() {
        return StructureModelManager.INSTANCE;
    }

    public void logEvent(String message) {
        if (this.logPrintStream != null) {
            this.logPrintStream.println("<AJDE> " + message);
        }
    }
}

