/*
 * Decompiled with CFR 0.152.
 */
package de.codedo.jaas;

import de.codedo.jaas.PamPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;

public class PamLoginModule
implements LoginModule {
    public static final String SERVICE_KEY = "service";
    private PAM _pam;
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    private Map<String, ?> _options;
    private String _username;
    private String _password;
    private boolean _authSucceeded = false;
    private PamPrincipal _principal;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this._subject = subject;
        this._callbackHandler = callbackHandler;
        this._options = new HashMap(options);
    }

    @Override
    public boolean login() throws LoginException {
        this.initializePam();
        this.obtainUserAndPassword();
        return this.performLogin();
    }

    private void initializePam() throws LoginException {
        String service = (String)this._options.get(SERVICE_KEY);
        if (service == null) {
            throw new LoginException("Error: PAM service was not defined");
        }
        this.createPam(service);
    }

    private void createPam(String service) throws LoginException {
        try {
            this._pam = new PAM(service);
        }
        catch (PAMException ex) {
            LoginException le = new LoginException("Error initializing PAM");
            le.initCause(ex);
            throw le;
        }
    }

    private void obtainUserAndPassword() throws LoginException {
        if (this._callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available  to gather authentication information from the user");
        }
        try {
            NameCallback nameCallback = new NameCallback("username");
            PasswordCallback passwordCallback = new PasswordCallback("password", false);
            this.invokeCallbackHandler(nameCallback, passwordCallback);
            this.initUserName(nameCallback);
            this.initPassword(passwordCallback);
        }
        catch (IOException | UnsupportedCallbackException ex) {
            LoginException le = new LoginException("Error in callbacks");
            le.initCause(ex);
            throw le;
        }
    }

    private void invokeCallbackHandler(NameCallback nameCallback, PasswordCallback passwordCallback) throws IOException, UnsupportedCallbackException {
        Callback[] callbacks = new Callback[]{nameCallback, passwordCallback};
        this._callbackHandler.handle(callbacks);
    }

    private void initUserName(NameCallback nameCallback) {
        this._username = nameCallback.getName();
    }

    private void initPassword(PasswordCallback passwordCallback) {
        char[] password = passwordCallback.getPassword();
        this._password = new String(password);
        passwordCallback.clearPassword();
    }

    private boolean performLogin() throws LoginException {
        try {
            UnixUser user = this._pam.authenticate(this._username, this._password);
            this._principal = new PamPrincipal(user);
            this._authSucceeded = true;
            return true;
        }
        catch (PAMException ex) {
            FailedLoginException le = new FailedLoginException("Invalid username or password");
            le.initCause(ex);
            throw le;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this._authSucceeded) {
            return false;
        }
        if (this._subject.isReadOnly()) {
            this.cleanup();
            throw new LoginException("Subject is read-only");
        }
        Set<Principal> principals = this._subject.getPrincipals();
        if (!principals.contains(this._principal)) {
            principals.add(this._principal);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this._authSucceeded) {
            return false;
        }
        this.cleanup();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this._subject.isReadOnly()) {
            this.cleanup();
            throw new LoginException("Subject is read-only");
        }
        this._subject.getPrincipals().remove(this._principal);
        this.cleanup();
        return true;
    }

    private void cleanup() {
        this._authSucceeded = false;
        this._username = null;
        this._password = null;
        this._principal = null;
        this._pam.dispose();
    }
}

