/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import water.AutoBuffer;
import water.Iced;
import water.util.SB;

public class IcedBitSet
extends Iced {
    private byte[] _val;
    private int _byteoff;
    private int _nbits;
    private int _bitoff;

    public IcedBitSet(int nbits) {
        this(nbits, 0);
    }

    public IcedBitSet(int nbits, int bitoff) {
        if (bitoff + nbits <= 32) {
            bitoff = 0;
            nbits = 32;
        }
        int nbytes = IcedBitSet.bytes(nbits);
        this.fill(nbits <= 0 ? null : new byte[nbytes], 0, nbits, bitoff);
    }

    public void fill(byte[] v, int byteoff, int nbits, int bitoff) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        if (byteoff < 0) {
            throw new IndexOutOfBoundsException("byteoff < 0: " + byteoff);
        }
        if (bitoff < 0) {
            throw new IndexOutOfBoundsException("bitoff < 0: " + bitoff);
        }
        assert (v.length >= IcedBitSet.bytes(nbits));
        assert (byteoff + IcedBitSet.bytes(nbits) <= v.length);
        this._val = v;
        this._nbits = nbits;
        this._bitoff = bitoff;
        this._byteoff = byteoff;
    }

    public boolean isInRange(int idx) {
        return (idx -= this._bitoff) >= 0 && idx < this._nbits;
    }

    public boolean contains(int idx) {
        assert ((idx -= this._bitoff) >= 0 && idx < this._nbits) : "Must have " + this._bitoff + " <= idx <= " + (this._bitoff + this._nbits - 1) + ": " + idx;
        return (this._val[this._byteoff + (idx >> 3)] & 1 << (idx & 7)) != 0;
    }

    public void set(int idx) {
        assert ((idx -= this._bitoff) >= 0 && idx < this._nbits) : "Must have " + this._bitoff + " <= idx <= " + (this._bitoff + this._nbits - 1) + ": " + idx;
        int n = this._byteoff + (idx >> 3);
        this._val[n] = (byte)(this._val[n] | 1 << (idx & 7));
    }

    public void clear(int idx) {
        assert ((idx -= this._bitoff) >= 0 && idx < this._nbits) : "Must have 0 <= idx <= " + (this._nbits - 1) + ": " + idx;
        int n = this._byteoff + (idx >> 3);
        this._val[n] = (byte)(this._val[n] & ~(1 << (idx & 7)));
    }

    public int cardinality() {
        int nbits = 0;
        int bytes = this.numBytes();
        for (int i = 0; i < bytes; ++i) {
            nbits += Integer.bitCount(0xFF & this._val[this._byteoff + i]);
        }
        return nbits;
    }

    public int size() {
        return this._nbits;
    }

    private static int bytes(int nbits) {
        return (nbits - 1 >> 3) + 1;
    }

    public int numBytes() {
        return IcedBitSet.bytes(this._nbits);
    }

    public int max() {
        return this._bitoff + this._nbits;
    }

    public void compress2(AutoBuffer ab) {
        assert (this.max() <= 32);
        assert (this._byteoff == 0);
        assert (this._val.length == 4);
        ab.putA1(this._val, 4);
    }

    public void fill2(byte[] bits, AutoBuffer ab) {
        this.fill(bits, ab.position(), 32, 0);
        ab.skip(4);
    }

    public void compress3(AutoBuffer ab) {
        assert (this.max() > 32);
        assert (this._byteoff == 0);
        assert (this._val.length == this.numBytes());
        ab.put2((char)this._bitoff);
        ab.put4(this._nbits);
        ab.putA1(this._val, this._val.length);
    }

    public void fill3(byte[] bits, AutoBuffer ab) {
        char bitoff = ab.get2();
        int nbits = ab.get4();
        this.fill(bits, ab.position(), nbits, bitoff);
        ab.skip(IcedBitSet.bytes(nbits));
    }

    public String toString() {
        return this.toString(new SB()).toString();
    }

    public SB toString(SB sb) {
        sb.p("{");
        if (this._bitoff > 0) {
            sb.p("...").p(this._bitoff).p(" 0-bits... ");
        }
        int limit = this._nbits;
        int bytes = IcedBitSet.bytes(this._nbits);
        for (int i = 0; i < bytes; ++i) {
            if (i > 0) {
                sb.p(' ');
            }
            sb.p(IcedBitSet.byteToBinaryString(this._val[this._byteoff + i], limit));
            limit -= 8;
        }
        return sb.p("}");
    }

    static String byteToBinaryString(byte b, int limit) {
        StringBuilder sb = new StringBuilder();
        if (limit > 8) {
            limit = 8;
        }
        for (int i = 0; i < limit; ++i) {
            sb.append((char)(48 + (b & 1)));
            b = (byte)(b >> 1);
        }
        return sb.toString();
    }

    public String toStrArray() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this._val[this._byteoff]);
        int bytes = IcedBitSet.bytes(this._nbits);
        for (int i = 1; i < bytes; ++i) {
            sb.append(", ").append(this._val[this._byteoff + i]);
        }
        sb.append("}");
        return sb.toString();
    }

    public void toJava(SB sb, String varname, int col) {
        sb.p("!GenModel.bitSetContains(").p(varname).p(", ").p(this._nbits).p(", ").p(this._bitoff).p(", data[").p(col).p("])");
    }

    public void toJavaRangeCheck(SB sb, int col) {
        sb.p("GenModel.bitSetIsInRange(").p(this._nbits).p(", ").p(this._bitoff).p(", data[").p(col).p("])");
    }
}

