/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.concurrent.atomic.AtomicInteger;
import water.AutoBuffer;
import water.Freezable;
import water.H2O;
import water.TypeMap;

public final class IcedAtomicInt
extends AtomicInteger
implements Freezable {
    private static volatile int _frozeType = 0;

    public IcedAtomicInt() {
        super(0);
    }

    public IcedAtomicInt(int val) {
        super(val);
    }

    @Override
    public final AutoBuffer write(AutoBuffer ab) {
        ab.put4(this.get());
        return ab;
    }

    public final IcedAtomicInt read(AutoBuffer ab) {
        this.set(ab.get4());
        return this;
    }

    @Override
    public AutoBuffer writeJSON(AutoBuffer ab) {
        return ab.putJSON4(this.get());
    }

    public Freezable readJSON(AutoBuffer ab) {
        throw H2O.unimpl();
    }

    @Override
    public int frozenType() {
        if (_frozeType != 0) {
            return _frozeType;
        }
        _frozeType = TypeMap.getIcer(this).frozenType();
        return _frozeType;
    }

    @Override
    public byte[] asBytes() {
        return this.write(new AutoBuffer()).buf();
    }

    public IcedAtomicInt reloadFromBytes(byte[] ary) {
        return this.read(new AutoBuffer(ary));
    }

    public Freezable clone() {
        return new IcedAtomicInt(this.get());
    }
}

