/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.assign;

import water.DKV;
import water.Key;
import water.Value;
import water.fvec.Frame;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstTmpAssign
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"id", "frame"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "tmp=";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Key<Frame> id = Key.make(env.expand(asts[1].str()));
        Val srcVal = stk.track(asts[2].exec(env));
        Frame srcFrame = srcVal.getFrame();
        Value v = DKV.get(id);
        if (v != null) {
            if (v.get().equals(srcFrame)) {
                return (ValFrame)srcVal;
            }
            throw new IllegalArgumentException("Temp ID " + id + " already exists");
        }
        Frame dst = new Frame(id, srcFrame._names, srcFrame.vecs());
        return new ValFrame(env._ses.track_tmp(dst));
    }
}

