/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.params;

import water.rapids.Env;
import water.rapids.ast.AstParameter;
import water.rapids.vals.ValStr;
import water.util.ArrayUtils;

public class AstStr
extends AstParameter {
    private final ValStr _v;

    public AstStr() {
        this(null);
    }

    public AstStr(String str) {
        this._v = new ValStr(str);
    }

    @Override
    public String str() {
        return this._v.toString().replaceAll("^\"|^'|\"$|'$", "");
    }

    @Override
    public ValStr exec(Env env) {
        return this._v;
    }

    @Override
    public String toJavaString() {
        return "\"" + this.str() + "\"";
    }

    @Override
    public int[] columns(String[] names) {
        int i = ArrayUtils.find(names, this._v.getStr());
        if (i == -1) {
            throw new IllegalArgumentException("Column " + this._v.getStr() + " not found");
        }
        return new int[]{i};
    }

    public String getStr() {
        return this._v.getStr();
    }
}

