/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import water.H2O;
import water.Iced;

public class ParserInfo
extends Iced<ParserInfo> {
    final String name;
    final int prior;
    final boolean isParallelParseSupported;
    final boolean isStreamParseSupported;
    final boolean isSequentialParseSupported;
    final boolean isDomainProvided;
    public static final int TOO_MANY_KEYS_COUNT = 128;
    public static final int SMALL_FILE_NCHUNKS = 10;

    public ParserInfo(String name, int prior, boolean isParallelParseSupported, boolean isStreamParseSupported, boolean isSequentialParseSupported, boolean isDomainProvided) {
        this.name = name;
        this.prior = prior;
        this.isParallelParseSupported = isParallelParseSupported;
        this.isStreamParseSupported = isStreamParseSupported;
        this.isSequentialParseSupported = isSequentialParseSupported;
        this.isDomainProvided = isDomainProvided;
    }

    public ParserInfo(String name, int prior, boolean isParallelParseSupported, boolean isStreamParseSupported, boolean isDomainProvided) {
        this(name, prior, isParallelParseSupported, isStreamParseSupported, false, isDomainProvided);
    }

    public ParserInfo(String name, int prior, boolean isParallelParseSupported, boolean isDomainProvided) {
        this(name, prior, isParallelParseSupported, true, false, isDomainProvided);
    }

    public ParserInfo(String name, int prior, boolean isParallelParseSupported) {
        this(name, prior, isParallelParseSupported, false);
    }

    public String name() {
        return this.name;
    }

    public int priority() {
        return this.prior;
    }

    public ParseMethod parseMethod(int nfiles, int nchunks, boolean disableParallelParse, boolean isEncrypted) {
        if (isEncrypted) {
            if (!this.isStreamParseSupported()) {
                throw new UnsupportedOperationException("Parser " + this.name + " doesn't support encrypted files.");
            }
            return ParseMethod.StreamParse;
        }
        if (this.isLocalParseSupported() && (disableParallelParse || !this.isParallelParseSupported() || nfiles > 128 && nchunks <= 10)) {
            return this.getLocalParseMethod();
        }
        if (this.isParallelParseSupported()) {
            return ParseMethod.DistributedParse;
        }
        throw H2O.unimpl();
    }

    public boolean isParallelParseSupported() {
        return this.isParallelParseSupported;
    }

    public boolean isStreamParseSupported() {
        return this.isStreamParseSupported;
    }

    public boolean isSequentialParseSupported() {
        return this.isSequentialParseSupported;
    }

    private boolean isLocalParseSupported() {
        return this.isStreamParseSupported() || this.isSequentialParseSupported();
    }

    private ParseMethod getLocalParseMethod() {
        if (this.isStreamParseSupported()) {
            return ParseMethod.StreamParse;
        }
        if (this.isSequentialParseSupported()) {
            return ParseMethod.SequentialParse;
        }
        throw new UnsupportedOperationException("Local parse not supported.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParserInfo that = (ParserInfo)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "ParserInfo{name='" + this.name + '\'' + ", prior=" + this.prior + ", isParallelParseSupported=" + this.isParallelParseSupported + '}';
    }

    public static enum ParseMethod {
        StreamParse,
        DistributedParse,
        SequentialParse;

    }
}

