/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.SecretKeySpec;
import water.parser.DecryptionTool;

public class GenericDecryptionTool
extends DecryptionTool {
    private final byte[] _encoded_key;
    private final String _key_algo;
    private final String _cipher_spec;

    public GenericDecryptionTool(DecryptionTool.DecryptionSetup ds) {
        super(ds._decrypt_tool_id);
        SecretKeySpec secretKey = GenericDecryptionTool.readSecretKey(ds);
        this._key_algo = secretKey.getAlgorithm();
        this._encoded_key = secretKey.getEncoded();
        this._cipher_spec = ds._cipher_spec;
    }

    @Override
    public byte[] decryptFirstBytes(byte[] bits) {
        int len;
        Cipher cipher = this.createDecipherer();
        int bs = cipher.getBlockSize();
        if (bs > 0 && len % bs != 0 || bits[len - 1] == 0) {
            for (len = bits.length; len > 0 && bits[len - 1] == 0; --len) {
            }
            len = bs > 0 ? len - len % bs : len;
        }
        return cipher.update(bits, 0, len);
    }

    @Override
    public InputStream decryptInputStream(final InputStream is) {
        Cipher cipher = this.createDecipherer();
        return new CipherInputStream(is, cipher){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (b == null) {
                    return is.read(null, off, len);
                }
                return super.read(b, off, len);
            }

            @Override
            public int available() throws IOException {
                int avail = super.available();
                return avail > 0 ? avail : is.available();
            }
        };
    }

    private Cipher createDecipherer() {
        SecretKeySpec secKeySpec = new SecretKeySpec(this._encoded_key, this._key_algo);
        try {
            Cipher cipher = Cipher.getInstance(this._cipher_spec);
            cipher.init(2, secKeySpec);
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Cipher initialization failed", e);
        }
    }
}

