/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.crypto.spec.SecretKeySpec;
import water.DKV;
import water.Iced;
import water.Key;
import water.Keyed;
import water.fvec.ByteVec;
import water.fvec.Frame;
import water.parser.GenericDecryptionTool;
import water.parser.NullDecryptionTool;

public abstract class DecryptionTool
extends Keyed<DecryptionTool> {
    DecryptionTool(Key<DecryptionTool> key) {
        super(key);
    }

    public abstract byte[] decryptFirstBytes(byte[] var1);

    public abstract InputStream decryptInputStream(InputStream var1);

    public boolean isTransparent() {
        return false;
    }

    public static DecryptionTool get(Key<DecryptionTool> key) {
        if (key == null) {
            return new NullDecryptionTool();
        }
        DecryptionTool decrypt = (DecryptionTool)DKV.getGet(key);
        return decrypt == null ? new NullDecryptionTool() : decrypt;
    }

    static SecretKeySpec readSecretKey(DecryptionSetup ds) {
        Keyed ksObject = (Keyed)DKV.getGet(ds._keystore_id);
        ByteVec ksVec = (ByteVec)(ksObject instanceof Frame ? ((Frame)ksObject).vec(0) : ksObject);
        InputStream ksStream = ksVec.openStream(null);
        try {
            KeyStore keystore = KeyStore.getInstance(ds._keystore_type);
            keystore.load(ksStream, ds._password);
            if (!keystore.containsAlias(ds._key_alias)) {
                throw new IllegalArgumentException("Alias for key not found");
            }
            java.security.Key key = keystore.getKey(ds._key_alias, ds._password);
            return new SecretKeySpec(key.getEncoded(), key.getAlgorithm());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to load key " + ds._key_alias + " from keystore " + ds._keystore_id, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read keystore " + ds._keystore_id, e);
        }
    }

    public static DecryptionTool make(DecryptionSetup ds) {
        if (ds._decrypt_tool_id == null) {
            ds._decrypt_tool_id = Key.make();
        }
        try {
            Class<?> dtClass = DecryptionTool.class.getClassLoader().loadClass(ds._decrypt_impl);
            if (!DecryptionTool.class.isAssignableFrom(dtClass)) {
                throw new IllegalArgumentException("Class " + ds._decrypt_impl + " doesn't implement a Decryption Tool.");
            }
            Constructor<?> constructor = dtClass.getConstructor(DecryptionSetup.class);
            DecryptionTool dt = (DecryptionTool)constructor.newInstance(ds);
            DKV.put(dt);
            return dt;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unknown decrypt tool: " + ds._decrypt_impl, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Invalid implementation of Decryption Tool (missing constructor).", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class DecryptionSetup
    extends Iced<DecryptionSetup> {
        public Key<DecryptionTool> _decrypt_tool_id;
        public String _decrypt_impl = GenericDecryptionTool.class.getName();
        public Key<?> _keystore_id;
        public String _keystore_type;
        public String _key_alias;
        public char[] _password;
        public String _cipher_spec;
    }
}

