/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.fvec.NewChunk;
import water.parser.BufferedString;
import water.util.SetOfBytes;
import water.util.StringUtils;
import water.util.UnsafeUtils;

public class CStrChunk
extends Chunk {
    static final int NA = -1;
    protected static final int _OFF = 5;
    private int _valstart;
    public boolean _isAllASCII = false;

    public CStrChunk() {
    }

    public CStrChunk(String s, int len) {
        byte[] sBytes = StringUtils.bytesOf(s);
        sBytes = Arrays.copyOf(sBytes, sBytes.length + 1);
        sBytes[sBytes.length - 1] = 0;
        this.init(sBytes.length, StringUtils.bytesOf(s), len, len, null, null);
    }

    public CStrChunk(int sslen, byte[] ss, int sparseLen, int idxLen, int[] id, int[] is) {
        this.init(sslen, ss, sparseLen, idxLen, id, is);
    }

    private void init(int sslen, byte[] ss, int sparseLen, int idxLen, int[] id, int[] is) {
        int i;
        this._start = -1L;
        this._valstart = this.idx(idxLen);
        this._len = idxLen;
        this._mem = MemoryManager.malloc1(this._valstart + sslen, false);
        UnsafeUtils.set4(this._mem, 0, this._valstart);
        Arrays.fill(this._mem, 5, this._valstart, (byte)-1);
        for (i = 0; i < sparseLen; ++i) {
            UnsafeUtils.set4(this._mem, this.idx(id == null ? i : id[i]), is == null ? 0 : is[i]);
        }
        UnsafeUtils.copyMemory(ss, 0L, this._mem, this._valstart, sslen);
        this._isAllASCII = true;
        for (i = this._valstart; i < this._mem.length; ++i) {
            byte c = this._mem[i];
            if ((c & 0x80) != 128) continue;
            this._isAllASCII = false;
            break;
        }
        UnsafeUtils.set1(this._mem, 4, (byte)(this._isAllASCII ? 1 : 0));
    }

    private int idx(int i) {
        return 5 + (i << 2);
    }

    @Override
    public boolean setNA_impl(int idx) {
        return false;
    }

    @Override
    public boolean set_impl(int idx, float f) {
        if (Float.isNaN(f)) {
            return false;
        }
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, double d) {
        if (Double.isNaN(d)) {
            return false;
        }
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, long l) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, String str) {
        return false;
    }

    @Override
    public boolean isNA_impl(int idx) {
        int off = this.intAt(idx);
        return off == -1;
    }

    public int intAt(int i) {
        return UnsafeUtils.get4(this._mem, this.idx(i));
    }

    public byte byteAt(int i) {
        return this._mem[this._valstart + i];
    }

    public int lengthAtOffset(int off) {
        int len = 0;
        while (this.byteAt(off + len) != 0) {
            ++len;
        }
        return len;
    }

    @Override
    public long at8_impl(int idx) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public double atd_impl(int idx) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public BufferedString atStr_impl(BufferedString bStr, int idx) {
        int off = this.intAt(idx);
        if (off == -1) {
            return null;
        }
        int len = this.lengthAtOffset(off);
        assert (len >= 0) : this.getClass().getSimpleName() + ".atStr_impl: len=" + len + ", idx=" + idx + ", off=" + off;
        return bStr.set(this._mem, this._valstart + off, len);
    }

    @Override
    protected final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this._valstart = UnsafeUtils.get4(this._mem, 0);
        byte b = UnsafeUtils.get1(this._mem, 4);
        this._isAllASCII = b != 0;
        this.set_len(this._valstart - 5 >> 2);
    }

    public ChunkVisitor processRows(ChunkVisitor nc, int from, int to) {
        BufferedString bs = new BufferedString();
        for (int i = from; i < to; ++i) {
            nc.addValue(this.atStr(bs, i));
        }
        return nc;
    }

    public ChunkVisitor processRows(ChunkVisitor nc, int ... rows) {
        BufferedString bs = new BufferedString();
        for (int i : rows) {
            nc.addValue(this.atStr(bs, i));
        }
        return nc;
    }

    public NewChunk asciiToLower(NewChunk nc) {
        nc = this.extractRows(nc, 0, this._len);
        for (int i = 0; i < nc._sslen; ++i) {
            if (nc._ss[i] <= 64 || nc._ss[i] >= 91) continue;
            int n = i;
            nc._ss[n] = (byte)(nc._ss[n] + 32);
        }
        return nc;
    }

    public NewChunk asciiToUpper(NewChunk nc) {
        nc = this.extractRows(nc, 0, this._len);
        for (int i = 0; i < nc._sslen; ++i) {
            if (nc._ss[i] <= 96 || nc._ss[i] >= 123) continue;
            int n = i;
            nc._ss[n] = (byte)(nc._ss[n] - 32);
        }
        return nc;
    }

    public NewChunk asciiTrim(NewChunk nc) {
        nc = this.extractRows(nc, 0, this._len);
        for (int i = 0; i < this._len; ++i) {
            int j = 0;
            int off = UnsafeUtils.get4(this._mem, this.idx(i));
            if (off == -1) continue;
            while (this._mem[this._valstart + off + j] > 0 && this._mem[this._valstart + off + j] < 33) {
                ++j;
            }
            if (j > 0) {
                nc.set_is(i, off + j);
            }
            while (this._mem[this._valstart + off + j] != 0) {
                ++j;
            }
            --j;
            while (this._mem[this._valstart + off + j] > 0 && this._mem[this._valstart + off + j] < 33) {
                nc._ss[off + j] = 0;
                --j;
            }
        }
        return nc;
    }

    public NewChunk asciiSubstring(NewChunk nc, int startIndex, int endIndex) {
        nc = this.extractRows(nc, 0, this._len);
        for (int i = 0; i < this._len; ++i) {
            int off = UnsafeUtils.get4(this._mem, this.idx(i));
            if (off == -1) continue;
            int len = 0;
            while (this._mem[this._valstart + off + len] != 0) {
                ++len;
            }
            nc.set_is(i, startIndex < len ? off + startIndex : off + len);
            while (len > endIndex - 1) {
                nc._ss[off + len] = 0;
                --len;
            }
        }
        return nc;
    }

    public NewChunk asciiLength(NewChunk nc) {
        nc.alloc_mantissa(this._len);
        nc.alloc_exponent(this._len);
        for (int i = 0; i < this._len; ++i) {
            int off = UnsafeUtils.get4(this._mem, this.idx(i));
            int len = 0;
            if (off != -1) {
                while (this._mem[this._valstart + off + len] != 0) {
                    ++len;
                }
                nc.addNum(len, 0);
                continue;
            }
            nc.addNA();
        }
        return nc;
    }

    public NewChunk asciiEntropy(NewChunk nc) {
        nc.alloc_doubles(this._len);
        for (int i = 0; i < this._len; ++i) {
            double entropy = this.entropyAt(i);
            if (Double.isNaN(entropy)) {
                nc.addNA();
                continue;
            }
            nc.addNum(entropy);
        }
        return nc;
    }

    double entropyAt(int i) {
        int off = this.intAt(i);
        if (off == -1) {
            return Double.NaN;
        }
        int[] frq = new int[256];
        int len = this.lengthAtOffset(off);
        for (int j = 0; j < len; ++j) {
            int n = 0xFF & this.byteAt(off + j);
            frq[n] = frq[n] + 1;
        }
        double sum = 0.0;
        for (int b = 0; b < 256; ++b) {
            int f = frq[b];
            if (f <= 0) continue;
            double x = (double)f / (double)len;
            sum += x * Math.log(x);
        }
        return -sum / Math.log(2.0);
    }

    public NewChunk asciiLStrip(NewChunk nc, String chars) {
        SetOfBytes set = new SetOfBytes(chars);
        for (int i = 0; i < this._len; ++i) {
            int off = this.intAt(i);
            if (off != -1) {
                while (set.contains(this.byteAt(off))) {
                    ++off;
                }
                int len = this.lengthAtOffset(off);
                nc.addStr(new BufferedString(this._mem, this._valstart + off, len));
                continue;
            }
            nc.addNA();
        }
        return nc;
    }

    public NewChunk asciiRStrip(NewChunk nc, String chars) {
        SetOfBytes set = new SetOfBytes(chars);
        for (int i = 0; i < this._len; ++i) {
            int off = this.intAt(i);
            if (off != -1) {
                int pos = off + this.lengthAtOffset(off);
                while (pos-- > off && set.contains(this.byteAt(pos))) {
                }
                nc.addStr(new BufferedString(this._mem, this._valstart + off, pos - off + 1));
                continue;
            }
            nc.addNA();
        }
        return nc;
    }
}

