/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.io.IOException;
import java.io.InputStream;
import water.Job;
import water.Key;
import water.Value;
import water.fvec.C1NChunk;
import water.fvec.Vec;

public class ByteVec
extends Vec {
    public ByteVec(Key key, int rowLayout) {
        super(key, rowLayout);
    }

    @Override
    public C1NChunk chunkForChunkIdx(int cidx) {
        return (C1NChunk)super.chunkForChunkIdx(cidx);
    }

    @Override
    public long naCnt() {
        return 0L;
    }

    @Override
    public boolean isInt() {
        return true;
    }

    public byte[] getFirstBytes() {
        return this.getFirstChunkBytes();
    }

    final byte[] getFirstChunkBytes() {
        return this.chunkForChunkIdx((int)0)._mem;
    }

    public InputStream openStream(final Key job_key) {
        InputStream is = new InputStream(){
            final long[] sz = new long[1];
            private int _cidx;
            private int _pidx;
            private int _sz;
            private C1NChunk _c0;

            @Override
            public int available() {
                if (this._c0 == null || this._sz >= this._c0._len) {
                    this.sz[0] = this.sz[0] + (this._c0 != null ? (long)this._c0._len : 0L);
                    if (this._cidx >= ByteVec.this.nChunks()) {
                        return 0;
                    }
                    this._c0 = ByteVec.this.chunkForChunkIdx(this._cidx++);
                    this._sz = 0;
                    if (job_key != null) {
                        Job.update(this._c0._len, job_key);
                    }
                }
                return this._c0._len - this._sz;
            }

            @Override
            public void close() {
                this._cidx = ByteVec.this.nChunks();
                this._c0 = null;
                this._sz = 0;
            }

            @Override
            public int read() throws IOException {
                return this.available() == 0 ? -1 : 0xFF & this._c0._mem[this._sz++];
            }

            @Override
            public int read(byte[] b, int off, int len) {
                if (b == null) {
                    Value v;
                    if (this._cidx > this._pidx && (v = Value.STORE_get(ByteVec.this.chunkKey(this._pidx++))) != null && v.isPersisted()) {
                        v.freePOJO();
                        v.freeMem();
                    }
                    return this._cidx;
                }
                int sz = this.available();
                if (sz == 0) {
                    return -1;
                }
                len = Math.min(len, sz);
                System.arraycopy(this._c0._mem, this._sz, b, off, len);
                this._sz += len;
                return len;
            }
        };
        try {
            is.available();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return is;
    }
}

