/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.concurrent.CancellationException;
import jsr166y.CountedCompleter;
import water.H2O;
import water.MrFun;

public class LocalMR<T extends MrFun<T>>
extends H2O.H2OCountedCompleter<LocalMR> {
    private int _lo;
    private int _hi;
    MrFun _mrFun;
    volatile Throwable _t;
    private volatile boolean _cancelled;
    private LocalMR<T> _root;
    private LocalMR<T> _left;
    private LocalMR<T> _rite;
    private boolean _reusePrevTsk = true;
    private final LocalMR<T> _prevTsk;
    volatile boolean completed;
    volatile boolean started;

    public LocalMR(MrFun mrt, int nthreads) {
        this(mrt, nthreads, null);
    }

    public LocalMR(MrFun mrt, H2O.H2OCountedCompleter cc) {
        this(mrt, H2O.NUMCPUS, cc);
    }

    public LocalMR(MrFun mrt, int nthreads, H2O.H2OCountedCompleter cc) {
        super(cc);
        if (nthreads <= 0) {
            throw new IllegalArgumentException("nthreads must be positive");
        }
        this._root = this;
        this._mrFun = mrt;
        this._lo = 0;
        this._hi = nthreads;
        this._prevTsk = null;
    }

    public LocalMR<T> withNoPrevTaskReuse() {
        this._reusePrevTsk = false;
        return this;
    }

    public boolean isReproducible() {
        return !this._reusePrevTsk;
    }

    private LocalMR(LocalMR src, LocalMR prevTsk, int lo, int hi) {
        super(src);
        this._root = src._root;
        this._reusePrevTsk = src._reusePrevTsk;
        this._prevTsk = this._reusePrevTsk ? prevTsk : null;
        this._lo = lo;
        this._hi = hi;
        this._cancelled = src._cancelled;
    }

    public boolean isCancelRequested() {
        return this._root._cancelled;
    }

    private int mid() {
        return this._lo + (this._hi - this._lo >> 1);
    }

    @Override
    public final void compute2() {
        this.started = true;
        if (this._root._cancelled) {
            this.tryComplete();
            return;
        }
        int mid = this.mid();
        assert (this._hi > this._lo);
        if (this._hi - this._lo >= 2) {
            this._left = new LocalMR<T>(this, this._prevTsk, this._lo, mid);
            if (mid < this._hi) {
                this.addToPendingCount(1);
                this._rite = new LocalMR<T>(this, this._left, mid, this._hi);
                this._rite.fork();
            }
            this._left.compute2();
        } else {
            block10: {
                if (this._prevTsk != null && this._prevTsk.completed) {
                    this._mrFun = this._prevTsk._mrFun;
                    this._prevTsk._mrFun = null;
                } else if (this != this._root) {
                    this._mrFun = this._root._mrFun.makeCopy();
                }
                try {
                    this._mrFun.map(mid);
                }
                catch (Throwable t) {
                    if (this._root._t != null) break block10;
                    this._root._t = t;
                    this._root._cancelled = true;
                }
            }
            this.tryComplete();
        }
    }

    @Override
    public final void onCompletion(CountedCompleter cc) {
        block14: {
            try {
                if (this._cancelled) {
                    assert (this == this._root);
                    this.completeExceptionally(this._t == null ? new CancellationException() : this._t);
                    return;
                }
                if (this._root._cancelled) {
                    return;
                }
                if (this._left != null && this._left._mrFun != null && this._mrFun != this._left._mrFun) {
                    assert (this._left.completed);
                    if (this._mrFun == null) {
                        this._mrFun = this._left._mrFun;
                    } else {
                        this._mrFun.reduce(this._left._mrFun);
                    }
                }
                if (this._rite != null && this._mrFun != this._rite._mrFun) {
                    assert (this._rite.completed);
                    if (this._mrFun == null) {
                        this._mrFun = this._rite._mrFun;
                    } else {
                        this._mrFun.reduce(this._rite._mrFun);
                    }
                }
                this._left = null;
                this._rite = null;
                this.completed = true;
            }
            catch (Throwable t) {
                if (this == this._root) {
                    this.completeExceptionally(t);
                }
                if (this._root._t != null) break block14;
                this._root._t = t;
                this._root._cancelled = true;
            }
        }
    }
}

