/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.LinkFunction;
import hex.LogitFunction;
import hex.genmodel.utils.DistributionFamily;

class ModifiedHuberDistribution
extends Distribution {
    public ModifiedHuberDistribution(DistributionFamily family) {
        super(family, (LinkFunction)new LogitFunction());
    }

    @Override
    public double deviance(double w, double y, double f) {
        double yf = (2.0 * y - 1.0) * f;
        if (yf < -1.0) {
            return -w * 4.0 * yf;
        }
        if (yf > 1.0) {
            return 0.0;
        }
        return w * yf * yf;
    }

    @Override
    public double negHalfGradient(double y, double f) {
        double yf = (2.0 * y - 1.0) * f;
        if (yf < -1.0) {
            return 2.0 * (2.0 * y - 1.0);
        }
        if (yf > 1.0) {
            return 0.0;
        }
        return -f * (2.0 * y - 1.0) * (2.0 * y - 1.0);
    }

    @Override
    public double initFNum(double w, double o, double y) {
        return y == 1.0 ? w : 0.0;
    }

    @Override
    public double initFDenom(double w, double o, double y) {
        return y == 1.0 ? 0.0 : w;
    }

    @Override
    public double gammaNum(double w, double y, double z, double f) {
        double yf = (2.0 * y - 1.0) * f;
        if (yf < -1.0) {
            return w * 4.0 * (2.0 * y - 1.0);
        }
        if (yf > 1.0) {
            return 0.0;
        }
        return w * 2.0 * (2.0 * y - 1.0) * (1.0 - yf);
    }

    @Override
    public double gammaDenom(double w, double y, double z, double f) {
        double yf = (2.0 * y - 1.0) * f;
        if (yf < -1.0) {
            return -w * 4.0 * yf;
        }
        if (yf > 1.0) {
            return 0.0;
        }
        return w * (1.0 - yf) * (1.0 - yf);
    }
}

