/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.ModelBuilder;
import org.apache.log4j.Logger;
import water.Job;

public class CVModelBuilder {
    private static final Logger LOG = Logger.getLogger(CVModelBuilder.class);
    private final Job job;
    private final ModelBuilder<?, ?, ?>[] modelBuilders;
    private final int parallelization;

    public CVModelBuilder(Job job, ModelBuilder<?, ?, ?>[] modelBuilders, int parallelization) {
        this.job = job;
        this.modelBuilders = modelBuilders;
        this.parallelization = parallelization;
    }

    protected void prepare(ModelBuilder m) {
    }

    protected void finished(ModelBuilder m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulkBuildModels() {
        int i;
        int N = this.modelBuilders.length;
        ModelBuilder.TrainModelTaskController[] submodel_tasks = new ModelBuilder.TrainModelTaskController[N];
        int nRunning = 0;
        RuntimeException rt = null;
        for (i = 0; i < N; ++i) {
            if (this.job.stop_requested()) {
                LOG.info((Object)("Skipping build of last " + (N - i) + " out of " + N + " cross-validation models"));
                this.stopAll(submodel_tasks);
                throw new Job.JobCancelledException();
            }
            LOG.info((Object)("Building cross-validation model " + (i + 1) + " / " + N + "."));
            this.prepare(this.modelBuilders[i]);
            this.modelBuilders[i].startClock();
            submodel_tasks[i] = this.modelBuilders[i].submitTrainModelTask();
            if (++nRunning != this.parallelization) continue;
            while (nRunning > 0) {
                int waitForTaskIndex = i + 1 - nRunning;
                try {
                    submodel_tasks[waitForTaskIndex].join();
                    this.finished(this.modelBuilders[waitForTaskIndex]);
                }
                catch (RuntimeException t) {
                    if (rt == null) {
                        LOG.info((Object)("Exception from CV model #" + waitForTaskIndex + " will be reported as main exception."));
                        rt = t;
                        continue;
                    }
                    LOG.warn((Object)("CV model #" + waitForTaskIndex + " failed, the exception will not be reported"), (Throwable)t);
                }
                finally {
                    LOG.info((Object)("Completed cross-validation model " + waitForTaskIndex + " / " + N + "."));
                    --nRunning;
                }
            }
            if (rt == null) continue;
            throw rt;
        }
        for (i = 0; i < N; ++i) {
            try {
                ModelBuilder.TrainModelTaskController task = submodel_tasks[i];
                assert (task != null);
                task.join();
                continue;
            }
            catch (RuntimeException t) {
                if (rt == null) {
                    LOG.info((Object)("Exception from CV model #" + i + " will be reported as main exception."));
                    rt = t;
                    continue;
                }
                LOG.warn((Object)("CV model #" + i + " failed, the exception will not be reported"), (Throwable)t);
                continue;
            }
            finally {
                LOG.info((Object)("Completed cross-validation model " + i + " / " + N + "."));
            }
        }
        if (rt != null) {
            throw rt;
        }
    }

    private void stopAll(ModelBuilder.TrainModelTaskController[] tasks) {
        for (ModelBuilder.TrainModelTaskController task : tasks) {
            if (task == null) continue;
            task.cancel(true);
        }
    }
}

