/*
 * Decompiled with CFR 0.152.
 */
package ai.api.ui;

import ai.api.R;
import ai.api.ui.MaskedColorView;
import ai.api.ui.SoundLevelCircleDrawable;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

public class SoundLevelButton
extends MaskedColorView {
    private static final String TAG = SoundLevelButton.class.getName();
    protected static final int[] STATE_LISTENING = new int[]{R.attr.state_listening};
    private final SoundLevelCircleDrawable backgroundDrawable;
    protected boolean listening = false;

    public SoundLevelButton(@NonNull Context context) {
        super(context);
        this.backgroundDrawable = new SoundLevelCircleDrawable(this.getParams(context, null));
        this.setCircleBackground(this.backgroundDrawable);
        this.init();
    }

    public SoundLevelButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.backgroundDrawable = new SoundLevelCircleDrawable(this.getParams(context, attrs));
        this.setCircleBackground(this.backgroundDrawable);
        this.init();
    }

    public SoundLevelButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.backgroundDrawable = new SoundLevelCircleDrawable(this.getParams(context, attrs));
        this.setCircleBackground(this.backgroundDrawable);
        this.init();
    }

    private void init() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SoundLevelButton.this.onClick(v);
            }
        });
    }

    protected void onClick(View v) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private SoundLevelCircleDrawable.Params getParams(@NonNull Context context, @Nullable AttributeSet attrs) {
        if (attrs != null) {
            TypedArray viewAttrs = context.obtainStyledAttributes(attrs, R.styleable.SoundLevelButton);
            try {
                this.listening = viewAttrs.getBoolean(R.styleable.SoundLevelButton_state_listening, false);
                float maxRadius = viewAttrs.getDimension(R.styleable.SoundLevelButton_maxRadius, -1.0f);
                float minRadius = viewAttrs.getDimension(R.styleable.SoundLevelButton_minRadius, -1.0f);
                float circleCenterX = viewAttrs.getDimension(R.styleable.SoundLevelButton_circleCenterX, -1.0f);
                float circleCenterY = viewAttrs.getDimension(R.styleable.SoundLevelButton_circleCenterY, -1.0f);
                int centerColor = viewAttrs.getColor(R.styleable.SoundLevelButton_centerColor, -889815);
                int haloColor = viewAttrs.getColor(R.styleable.SoundLevelButton_haloColor, SoundLevelCircleDrawable.HALO_COLOR_DEF);
                SoundLevelCircleDrawable.Params params = new SoundLevelCircleDrawable.Params(maxRadius, minRadius, circleCenterX, circleCenterY, centerColor, haloColor);
                return params;
            }
            finally {
                viewAttrs.recycle();
            }
        }
        return null;
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] state = super.onCreateDrawableState(extraSpace + 1);
        if (this.listening) {
            SoundLevelButton.mergeDrawableStates((int[])state, (int[])STATE_LISTENING);
        }
        return state;
    }

    @TargetApi(value=16)
    private void setCircleBackground(SoundLevelCircleDrawable soundLevelCircleDrawable) {
        if (Build.VERSION.SDK_INT < 16) {
            this.setBackgroundDrawable(soundLevelCircleDrawable);
        } else {
            this.setBackground(soundLevelCircleDrawable);
        }
    }

    public void setDrawSoundLevel(boolean drawSoundLevel) {
        this.listening = drawSoundLevel;
        this.backgroundDrawable.setDrawSoundLevel(drawSoundLevel);
        this.refreshDrawableState();
        this.postInvalidate();
    }

    protected void setDrawCenter(boolean drawCenter) {
        this.backgroundDrawable.setDrawCenter(drawCenter);
    }

    public void setSoundLevel(float soundLevel) {
        this.backgroundDrawable.setSoundLevel(soundLevel);
        this.postInvalidate();
    }

    @Override
    protected String getDebugState() {
        return super.getDebugState() + "\ndrawSL: " + this.listening;
    }

    protected float getMinRadius() {
        return this.backgroundDrawable.getMinRadius();
    }
}

