/*
 * Decompiled with CFR 0.152.
 */
package ai.api.ui;

import ai.api.R;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageView;

public class MaskedColorView
extends ImageView {
    private ColorStateList colorStateList = null;

    public MaskedColorView(Context context) {
        super(context, null);
    }

    public MaskedColorView(Context context, AttributeSet attrs) {
        super(context, attrs, 16842866);
        this.configure(attrs);
    }

    public MaskedColorView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.configure(attrs);
    }

    @TargetApi(value=11)
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.setColorFilter(this.getCurrentColor(this.getDrawableState()), PorterDuff.Mode.SRC_ATOP);
        if (Build.VERSION.SDK_INT >= 11) {
            this.jumpDrawablesToCurrentState();
        }
    }

    public void setColorStateList(ColorStateList colorStateList) {
        this.colorStateList = colorStateList;
    }

    private int getCurrentColor(int[] stateSet) {
        return this.colorStateList == null ? -65281 : this.colorStateList.getColorForState(stateSet, this.colorStateList.getDefaultColor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.MaskedColorView);
            try {
                ColorStateList csl = a.getColorStateList(R.styleable.MaskedColorView_mainColor);
                if (csl != null) {
                    this.colorStateList = csl;
                }
            }
            finally {
                a.recycle();
            }
        }
    }

    protected String getDebugState() {
        return "====\ncsl is " + (this.colorStateList != null ? "NOT" : "") + " null";
    }
}

