/*
 * Decompiled with CFR 0.152.
 */
package ai.api.ui;

import ai.api.AIConfiguration;
import ai.api.AIListener;
import ai.api.AIService;
import ai.api.AIServiceException;
import ai.api.PartialResultsListener;
import ai.api.R;
import ai.api.model.AIError;
import ai.api.model.AIRequest;
import ai.api.model.AIResponse;
import ai.api.services.GoogleRecognitionServiceImpl;
import ai.api.ui.SoundLevelButton;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AIButton
extends SoundLevelButton
implements AIListener {
    private static final String TAG = AIButton.class.getName();
    protected static final int[] STATE_WAITING = new int[]{R.attr.state_waiting};
    protected static final int[] STATE_SPEAKING = new int[]{R.attr.state_speaking};
    private float animationStage = 0.0f;
    private boolean animationSecondPhase = false;
    private final WaitingAnimation animation = new WaitingAnimation();
    private AIService aiService;
    private AIButtonListener resultsListener;
    private PartialResultsListener partialResultsListener;
    private final ExecutorService eventsExecutor = Executors.newSingleThreadExecutor();
    private volatile MicState currentState = MicState.normal;

    @Override
    public void onResult(AIResponse result) {
        this.post(new Runnable(){

            @Override
            public void run() {
                AIButton.this.changeState(MicState.normal);
            }
        });
        if (this.resultsListener != null) {
            this.resultsListener.onResult(result);
        }
    }

    @Override
    public void onError(AIError error) {
        this.post(new Runnable(){

            @Override
            public void run() {
                AIButton.this.changeState(MicState.normal);
            }
        });
        if (this.resultsListener != null) {
            this.resultsListener.onError(error);
        }
    }

    @Override
    public void onAudioLevel(float level) {
        this.setSoundLevel(level);
    }

    @Override
    public void onListeningStarted() {
        this.post(new Runnable(){

            @Override
            public void run() {
                AIButton.this.changeState(MicState.listening);
            }
        });
    }

    @Override
    public void onListeningCanceled() {
        this.post(new Runnable(){

            @Override
            public void run() {
                AIButton.this.changeState(MicState.normal);
            }
        });
        if (this.resultsListener != null) {
            this.resultsListener.onCancelled();
        }
    }

    @Override
    public void onListeningFinished() {
        this.post(new Runnable(){

            @Override
            public void run() {
                AIButton.this.changeState(MicState.busy);
            }
        });
    }

    public AIButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public AIButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AIButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray viewAttrs = context.obtainStyledAttributes(attrs, R.styleable.SoundLevelButton);
            try {
                this.currentState = MicState.fromAttrs(viewAttrs);
            }
            finally {
                viewAttrs.recycle();
            }
        }
    }

    public void initialize(AIConfiguration config) {
        this.aiService = AIService.getService(this.getContext(), config);
        this.aiService.setListener(this);
        if (this.aiService instanceof GoogleRecognitionServiceImpl) {
            ((GoogleRecognitionServiceImpl)this.aiService).setPartialResultsListener(new PartialResultsListener(){

                @Override
                public void onPartialResults(List<String> partialResults) {
                    if (AIButton.this.partialResultsListener != null) {
                        AIButton.this.partialResultsListener.onPartialResults(partialResults);
                    }
                }
            });
        }
    }

    public void setResultsListener(AIButtonListener resultsListener) {
        this.resultsListener = resultsListener;
    }

    public void setPartialResultsListener(PartialResultsListener partialResultsListener) {
        this.partialResultsListener = partialResultsListener;
    }

    public void startListening() {
        if (this.aiService != null) {
            if (this.currentState == MicState.normal) {
                this.eventsExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        AIButton.this.aiService.startListening();
                    }
                });
            }
        } else {
            throw new IllegalStateException("Call initialize method before usage");
        }
    }

    public AIResponse textRequest(AIRequest request) throws AIServiceException {
        if (this.aiService != null) {
            return this.aiService.textRequest(request);
        }
        throw new IllegalStateException("Call initialize method before usage");
    }

    public AIResponse textRequest(String request) throws AIServiceException {
        return this.textRequest(new AIRequest(request));
    }

    public AIService getAIService() {
        return this.aiService;
    }

    @Override
    protected void onClick(View v) {
        super.onClick(v);
        if (this.aiService != null) {
            switch (this.currentState) {
                case normal: {
                    this.eventsExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            AIButton.this.aiService.startListening();
                        }
                    });
                    break;
                }
                case busy: {
                    this.eventsExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            AIButton.this.aiService.cancel();
                        }
                    });
                    break;
                }
                default: {
                    this.eventsExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            AIButton.this.aiService.stopListening();
                        }
                    });
                }
            }
        }
    }

    @Override
    public int[] onCreateDrawableState(int extraSpace) {
        int[] state = super.onCreateDrawableState(extraSpace + 1);
        if (this.currentState != null) {
            switch (this.currentState) {
                case normal: {
                    break;
                }
                case busy: {
                    AIButton.mergeDrawableStates((int[])state, (int[])STATE_WAITING);
                    break;
                }
                case listening: {
                    AIButton.mergeDrawableStates((int[])state, (int[])STATE_LISTENING);
                    break;
                }
                case speaking: {
                    AIButton.mergeDrawableStates((int[])state, (int[])STATE_SPEAKING);
                }
            }
        }
        return state;
    }

    public void resume() {
        if (this.aiService != null) {
            this.aiService.resume();
        }
    }

    public void pause() {
        this.cancelListening();
        if (this.aiService != null) {
            this.aiService.pause();
        }
    }

    private void cancelListening() {
        if (this.aiService != null && this.currentState != MicState.normal) {
            this.aiService.cancel();
            this.changeState(MicState.normal);
        }
    }

    private void changeState(MicState toState) {
        switch (toState) {
            case normal: {
                this.stopProcessingAnimation();
                this.setDrawSoundLevel(false);
                break;
            }
            case busy: {
                this.startProcessingAnimation();
                this.setDrawSoundLevel(false);
                break;
            }
            case listening: {
                this.stopProcessingAnimation();
                this.setDrawSoundLevel(true);
                break;
            }
            case speaking: {
                this.stopProcessingAnimation();
                this.setDrawSoundLevel(false);
            }
        }
        this.currentState = toState;
        this.refreshDrawableState();
    }

    private void startProcessingAnimation() {
        this.setDrawCenter(true);
        this.animationSecondPhase = false;
        this.startAnimation(this.animation);
    }

    private void stopProcessingAnimation() {
        this.setDrawCenter(false);
        this.clearAnimation();
        this.animationStage = 0.0f;
        this.animationSecondPhase = false;
        this.postInvalidate();
    }

    @Override
    protected String getDebugState() {
        return super.getDebugState() + "\nst:" + (Object)((Object)this.currentState);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.animationStage > 0.0f || this.animationSecondPhase) {
            float sweepAngle;
            float startingAngle;
            float center = (float)this.getWidth() / 2.0f;
            float radius = this.getMinRadius() * 1.25f;
            RectF size = new RectF(center - radius, center - radius, center + radius, center + radius);
            Paint paint = new Paint();
            paint.setColor(this.getResources().getColor(R.color.icon_orange_color));
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth((float)AIButton.dpToPixels(this.getContext(), 4.0f));
            paint.setStrokeCap(Paint.Cap.ROUND);
            paint.setAntiAlias(true);
            if ((double)this.animationStage < 0.5 && !this.animationSecondPhase) {
                startingAngle = 0.0f;
                sweepAngle = this.animationStage * 360.0f;
            } else {
                startingAngle = (this.animationStage - 0.5f) * 360.0f;
                sweepAngle = 180.0f;
                this.animationSecondPhase = true;
            }
            canvas.drawArc(size, 270.0f + startingAngle, sweepAngle, false, paint);
        }
    }

    private static int dpToPixels(Context context, float dp) {
        Resources r = context.getResources();
        return Math.round(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics()));
    }

    private class WaitingAnimation
    extends Animation {
        protected WaitingAnimation() {
            this.setDuration(1500L);
            this.setRepeatCount(-1);
            this.setRepeatMode(1);
            this.setInterpolator((Interpolator)new LinearInterpolator());
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            AIButton.this.animationStage = interpolatedTime;
            AIButton.this.invalidate();
        }
    }

    public static enum MicState {
        normal,
        busy,
        listening,
        speaking;


        public static MicState fromAttrs(TypedArray viewAttrs) {
            if (viewAttrs.getBoolean(R.styleable.SoundLevelButton_state_listening, false)) {
                return listening;
            }
            if (viewAttrs.getBoolean(R.styleable.SoundLevelButton_state_waiting, false)) {
                return busy;
            }
            if (viewAttrs.getBoolean(R.styleable.SoundLevelButton_state_speaking, false)) {
                return speaking;
            }
            return normal;
        }
    }

    public static interface AIButtonListener {
        public void onResult(AIResponse var1);

        public void onError(AIError var1);

        public void onCancelled();
    }
}

