/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.meta.inputs.Input;
import scala.meta.internal.metals.Classfile$;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.Messages$WorkspaceSymbolDependencies$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.SemanticdbDefinition;
import scala.meta.internal.metals.SemanticdbDefinition$;
import scala.meta.internal.metals.WorkspaceSymbolQuery;
import scala.meta.internal.mtags.GlobalSymbolIndex;
import scala.meta.internal.mtags.Symbol;
import scala.meta.internal.mtags.Symbol$;
import scala.meta.internal.mtags.SymbolDefinition;
import scala.meta.internal.semanticdb.Scala;
import scala.meta.io.AbsolutePath;
import scala.meta.pc.SymbolSearchVisitor;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001\u0002\r\u001a\u0001\tB\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!I\u0005A!A!\u0002\u0013Q\u0005\"\u0002(\u0001\t\u0003y\u0005b\u0002,\u0001\u0005\u0004%Ia\u0016\u0005\u0007I\u0002\u0001\u000b\u0011\u0002-\t\u000f\u0015\u0004!\u0019!C\u0005/\"1a\r\u0001Q\u0001\naCqa\u001a\u0001C\u0002\u0013%\u0001\u000e\u0003\u0004y\u0001\u0001\u0006I!\u001b\u0005\u0006s\u0002!\tA\u001f\u0005\n\u0003\u0013\u0001!\u0019!C\u0005\u0003\u0017A\u0001\"a\u0005\u0001A\u0003%\u0011Q\u0002\u0005\n\u0003O\u0001!\u0019!C\u0005\u0003SA\u0001\"a\u000f\u0001A\u0003%\u00111\u0006\u0005\b\u0003{\u0001A\u0011BA \u0011\u001d\t9\u0006\u0001C!\u00033Bq!!\u0018\u0001\t\u0003\ny\u0006C\u0004\u0002\u0014\u0002!\t%!&\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005&AF,pe.\u001c\b/Y2f'\u0016\f'o\u00195WSNLGo\u001c:\u000b\u0005iY\u0012AB7fi\u0006d7O\u0003\u0002\u001d;\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u001f?\u0005!Q.\u001a;b\u0015\u0005\u0001\u0013!B:dC2\f7\u0001A\n\u0003\u0001\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R!AJ\u000f\u0002\u0005A\u001c\u0017B\u0001\u0015&\u0005M\u0019\u00160\u001c2pYN+\u0017M]2i-&\u001c\u0018\u000e^8s\u0003%9xN]6ta\u0006\u001cW\r\u0005\u0002,]5\tAF\u0003\u0002.;\u0005\u0011\u0011n\\\u0005\u0003_1\u0012A\"\u00112t_2,H/\u001a)bi\"\fQ!];fef\u0004\"AM\u001a\u000e\u0003eI!\u0001N\r\u0003)]{'o[:qC\u000e,7+_7c_2\fV/\u001a:z\u0003\u0015!xn[3o!\t9\u0004)D\u00019\u0015\tI$(A\u0004kg>t'\u000f]2\u000b\u0005mb\u0014!\u00027taRR'BA\u001f?\u0003\u001d)7\r\\5qg\u0016T\u0011aP\u0001\u0004_J<\u0017BA!9\u00055\u0019\u0015M\\2fY\u000eCWmY6fe\u0006)\u0011N\u001c3fqB\u0011AiR\u0007\u0002\u000b*\u0011aiG\u0001\u0006[R\fwm]\u0005\u0003\u0011\u0016\u0013\u0011c\u00127pE\u0006d7+_7c_2Le\u000eZ3y\u0003M\u0019\u0018M^3DY\u0006\u001c8OR5mKR{G)[:l!\tYE*D\u0001 \u0013\tiuDA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0019\u0001\u0016KU*U+B\u0011!\u0007\u0001\u0005\u0006S\u0019\u0001\rA\u000b\u0005\u0006a\u0019\u0001\r!\r\u0005\u0006k\u0019\u0001\rA\u000e\u0005\u0006\u0005\u001a\u0001\ra\u0011\u0005\u0006\u0013\u001a\u0001\rAS\u0001\u000eMJ|WnV8sWN\u0004\u0018mY3\u0016\u0003a\u00032!\u00170a\u001b\u0005Q&BA.]\u0003\u0011)H/\u001b7\u000b\u0003u\u000bAA[1wC&\u0011qL\u0017\u0002\n\u0003J\u0014\u0018-\u001f'jgR\u0004\"!\u00192\u000e\u0003iJ!a\u0019\u001e\u0003#MKXNY8m\u0013:4wN]7bi&|g.\u0001\bge>lwk\u001c:lgB\f7-\u001a\u0011\u0002\u001b\u0019\u0014x.\\\"mCN\u001c\b/\u0019;i\u000391'o\\7DY\u0006\u001c8\u000f]1uQ\u0002\n\u0011CY;gM\u0016\u0014X\rZ\"mCN\u001c\b/\u0019;i+\u0005I\u0007cA-_UB!1j[7n\u0013\tawD\u0001\u0004UkBdWM\r\t\u0003]Vt!a\\:\u0011\u0005A|R\"A9\u000b\u0005I\f\u0013A\u0002\u001fs_>$h(\u0003\u0002u?\u00051\u0001K]3eK\u001aL!A^<\u0003\rM#(/\u001b8h\u0015\t!x$\u0001\nck\u001a4WM]3e\u00072\f7o\u001d9bi\"\u0004\u0013AC1mYJ+7/\u001e7ugR\t1\u0010\u0005\u0003}\u0003\u0007\u0001gBA?\u0000\u001d\t\u0001h0C\u0001!\u0013\r\t\taH\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)!a\u0002\u0003\u0007M+\u0017OC\u0002\u0002\u0002}\tABY=OC6,G*\u001a8hi\",\"!!\u0004\u0013\r\u0005=\u0011QCA\u0011\r\u0019\t\tb\u0004\u0001\u0002\u000e\taAH]3gS:,W.\u001a8u}\u0005i!-\u001f(b[\u0016dUM\\4uQ\u0002\u0002B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037a\u0016\u0001\u00027b]\u001eLA!a\b\u0002\u001a\t1qJ\u00196fGR\u0004B!WA\u0012A&\u0019\u0011Q\u0005.\u0003\u0015\r{W\u000e]1sCR|'/A\u0005jgZK7/\u001b;fIV\u0011\u00111\u0006\t\u0006\u0003[\t9DK\u0007\u0003\u0003_QA!!\r\u00024\u00059Q.\u001e;bE2,'bAA\u001b?\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u0012q\u0006\u0002\u0004'\u0016$\u0018AC5t-&\u001c\u0018\u000e^3eA\u0005QA-\u001a4j]&$\u0018n\u001c8\u0015\u0011\u0005\u0005\u0013QJA)\u0003+\u0002RaSA\"\u0003\u000fJ1!!\u0012 \u0005\u0019y\u0005\u000f^5p]B\u0019A)!\u0013\n\u0007\u0005-SI\u0001\tTs6\u0014w\u000e\u001c#fM&t\u0017\u000e^5p]\"1\u0011q\n\nA\u00025\f1\u0001]6h\u0011\u0019\t\u0019F\u0005a\u0001[\u0006Aa-\u001b7f]\u0006lW\rC\u0003C%\u0001\u00071)\u0001\ntQ>,H\u000e\u001a,jg&$\b+Y2lC\u001e,Gc\u0001&\u0002\\!1\u0011qJ\nA\u00025\fAC^5tSR<vN]6ta\u0006\u001cWmU=nE>dGCCA1\u0003O\nY(a \u0002\nB\u00191*a\u0019\n\u0007\u0005\u0015tDA\u0002J]RDq!!\u001b\u0015\u0001\u0004\tY'\u0001\u0003qCRD\u0007\u0003BA7\u0003oj!!a\u001c\u000b\t\u0005E\u00141O\u0001\u0005M&dWMC\u0002\u0002vq\u000b1A\\5p\u0013\u0011\tI(a\u001c\u0003\tA\u000bG\u000f\u001b\u0005\u0007\u0003{\"\u0002\u0019A7\u0002\rMLXNY8m\u0011\u001d\t\t\t\u0006a\u0001\u0003\u0007\u000bAa[5oIB\u0019\u0011-!\"\n\u0007\u0005\u001d%H\u0001\u0006Ts6\u0014w\u000e\\&j]\u0012Dq!a#\u0015\u0001\u0004\ti)A\u0003sC:<W\rE\u0002b\u0003\u001fK1!!%;\u0005\u0015\u0011\u0016M\\4f\u000391\u0018n]5u\u00072\f7o\u001d4jY\u0016$b!!\u0019\u0002\u0018\u0006e\u0005BBA(+\u0001\u0007Q\u000e\u0003\u0004\u0002TU\u0001\r!\\\u0001\fSN\u001c\u0015M\\2fY2,G\rF\u0001K\u0003=)\u0007\u0010]1oI\u000ec\u0017m]:gS2,GCBA1\u0003G\u000b)\u000b\u0003\u0004\u0002P]\u0001\r!\u001c\u0005\u0007\u0003':\u0002\u0019A7")
public class WorkspaceSearchVisitor
extends SymbolSearchVisitor {
    private final AbsolutePath workspace;
    private final WorkspaceSymbolQuery query;
    private final CancelChecker token;
    private final GlobalSymbolIndex index;
    private final boolean saveClassFileToDisk;
    private final ArrayList<SymbolInformation> fromWorkspace;
    private final ArrayList<SymbolInformation> fromClasspath;
    private final ArrayList<Tuple2<String, String>> bufferedClasspath;
    private final Comparator<SymbolInformation> byNameLength;
    private final Set<AbsolutePath> isVisited;

    private ArrayList<SymbolInformation> fromWorkspace() {
        return this.fromWorkspace;
    }

    private ArrayList<SymbolInformation> fromClasspath() {
        return this.fromClasspath;
    }

    private ArrayList<Tuple2<String, String>> bufferedClasspath() {
        return this.bufferedClasspath;
    }

    public Seq<SymbolInformation> allResults() {
        Object object;
        if (this.fromWorkspace().isEmpty()) {
            this.bufferedClasspath().forEach((Consumer<Tuple2<String, String>>)((Consumer<Tuple2>)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String pkg = (String)tuple2._1();
                String name = (String)tuple2._2();
                this.expandClassfile(pkg, name);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }));
        }
        this.fromWorkspace().sort(this.byNameLength());
        this.fromClasspath().sort(this.byNameLength());
        ArrayList<SymbolInformation> result = new ArrayList<SymbolInformation>();
        result.addAll(this.fromWorkspace());
        result.addAll(this.fromClasspath());
        if (!this.bufferedClasspath().isEmpty() && this.fromClasspath().isEmpty()) {
            AbsolutePath dependencies = this.workspace.resolve(Directories$.MODULE$.workspaceSymbol());
            if (!dependencies.isFile()) {
                MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(dependencies).writeText(Messages$WorkspaceSymbolDependencies$.MODULE$.title());
            }
            object = BoxesRunTime.boxToBoolean((boolean)result.add(new SymbolInformation(Messages$WorkspaceSymbolDependencies$.MODULE$.title(), SymbolKind.Event, new Location(dependencies.toURI().toString(), new Range(new Position(0, 0), new Position(0, 0))))));
        } else {
            object = BoxedUnit.UNIT;
        }
        return MetalsEnrichments$.MODULE$.ListHasAsScala(result).asScala().toSeq();
    }

    private Comparator<SymbolInformation> byNameLength() {
        return this.byNameLength;
    }

    private Set<AbsolutePath> isVisited() {
        return this.isVisited;
    }

    private Option<SymbolDefinition> definition(String pkg, String filename, GlobalSymbolIndex index) {
        List list;
        String nme = Classfile$.MODULE$.name(filename);
        Symbol tpe = Symbol$.MODULE$.apply(Scala.Symbols$.MODULE$.Global(pkg, (Scala.Descriptor)new Scala.Descriptor$.Type(nme)));
        List forTpe = index.definitions(tpe);
        if (forTpe.isEmpty()) {
            Symbol term = Symbol$.MODULE$.apply(Scala.Symbols$.MODULE$.Global(pkg, (Scala.Descriptor)new Scala.Descriptor$.Term(nme)));
            list = index.definitions(term);
        } else {
            list = forTpe;
        }
        List defs = list;
        return ((LinearSeqOps)defs.sortBy((Function1 & Serializable)x$1 -> x$1.path().toURI().toString(), (Ordering)Ordering.String$.MODULE$)).headOption();
    }

    public boolean shouldVisitPackage(String pkg) {
        return true;
    }

    public int visitWorkspaceSymbol(Path path, String symbol, SymbolKind kind, Range range) {
        Tuple2 tuple2 = Scala.DescriptorParser$.MODULE$.apply(symbol);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Scala.Descriptor desc = (Scala.Descriptor)tuple2._1();
        String owner = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)desc, (Object)owner);
        Tuple2 tuple23 = tuple22;
        Scala.Descriptor desc2 = (Scala.Descriptor)tuple23._1();
        String owner2 = (String)tuple23._2();
        this.fromWorkspace().add(new SymbolInformation(desc2.name().value(), kind, new Location(path.toUri().toString(), range), owner2.replace('/', '.')));
        return 1;
    }

    public int visitClassfile(String pkg, String filename) {
        int n;
        if (this.fromWorkspace().isEmpty() || this.query.isClasspath()) {
            n = this.expandClassfile(pkg, filename);
        } else {
            this.bufferedClasspath().add((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pkg), (Object)filename));
            n = 1;
        }
        return n;
    }

    public boolean isCancelled() {
        return MetalsEnrichments$.MODULE$.XtensionCancelChecker(this.token).isCancelled();
    }

    private int expandClassfile(String pkg, String filename) {
        BooleanRef isHit = BooleanRef.create((boolean)false);
        this.definition(pkg, filename, this.index).withFilter((Function1 & Serializable)defn -> BoxesRunTime.boxToBoolean((boolean)WorkspaceSearchVisitor.$anonfun$expandClassfile$1(this, defn))).foreach((Function1 & Serializable)defn -> {
            WorkspaceSearchVisitor.$anonfun$expandClassfile$2(this, isHit, defn);
            return BoxedUnit.UNIT;
        });
        return isHit.elem ? 1 : 0;
    }

    public static final /* synthetic */ boolean $anonfun$expandClassfile$1(WorkspaceSearchVisitor $this, SymbolDefinition defn) {
        return !$this.isVisited().apply((Object)defn.path());
    }

    public static final /* synthetic */ void $anonfun$expandClassfile$3(WorkspaceSearchVisitor $this, SymbolDefinition defn$1, BooleanRef isHit$1, SemanticdbDefinition semanticDefn) {
        block0: {
            if (!$this.query.matches(semanticDefn.info())) break block0;
            AbsolutePath path = $this.saveClassFileToDisk ? MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(defn$1.path()).toFileOnDisk($this.workspace) : defn$1.path();
            String uri = path.toURI().toString();
            $this.fromClasspath().add(semanticDefn.toLsp(uri));
            isHit$1.elem = true;
        }
    }

    public static final /* synthetic */ void $anonfun$expandClassfile$2(WorkspaceSearchVisitor $this, BooleanRef isHit$1, SymbolDefinition defn) {
        $this.isVisited().$plus$eq((Object)defn.path());
        Input.VirtualFile input = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(defn.path()).toInput();
        SemanticdbDefinition$.MODULE$.foreach(input, defn.dialect(), (Function1 & Serializable)semanticDefn -> {
            WorkspaceSearchVisitor.$anonfun$expandClassfile$3($this, defn, isHit$1, semanticDefn);
            return BoxedUnit.UNIT;
        });
    }

    public WorkspaceSearchVisitor(AbsolutePath workspace, WorkspaceSymbolQuery query, CancelChecker token, GlobalSymbolIndex index, boolean saveClassFileToDisk) {
        this.workspace = workspace;
        this.query = query;
        this.token = token;
        this.index = index;
        this.saveClassFileToDisk = saveClassFileToDisk;
        this.fromWorkspace = new ArrayList();
        this.fromClasspath = new ArrayList();
        this.bufferedClasspath = new ArrayList();
        this.byNameLength = new Comparator<SymbolInformation>(null){

            public Comparator<SymbolInformation> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<SymbolInformation> thenComparing(Comparator<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<SymbolInformation> thenComparing(Function<? super SymbolInformation, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<SymbolInformation> thenComparing(Function<? super SymbolInformation, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<SymbolInformation> thenComparingInt(ToIntFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<SymbolInformation> thenComparingLong(ToLongFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<SymbolInformation> thenComparingDouble(ToDoubleFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(SymbolInformation x, SymbolInformation y) {
                return Integer.compare(x.getName().length(), y.getName().length());
            }
        };
        this.isVisited = (Set)Set$.MODULE$.empty();
    }
}

