/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.SemanticdbFeatureProvider;
import scala.meta.internal.mtags.SemanticdbClasspath$;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import scribe.data.MDC$;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u000554A!\u0004\b\u0001/!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\"\u0002\u001d\u0001\t\u0003I\u0004\"\u0002 \u0001\t\u0003y\u0004\"B\"\u0001\t\u0003y\u0004\"\u0002#\u0001\t\u0003)\u0005\"B)\u0001\t\u0003\u0011\u0006\"B+\u0001\t\u00131\u0006\"B-\u0001\t\u0003Q\u0006\"B-\u0001\t\u0013!\u0007\"B-\u0001\t\u0003Y'!E*f[\u0006tG/[2eE&sG-\u001a=fe*\u0011q\u0002E\u0001\u0007[\u0016$\u0018\r\\:\u000b\u0005E\u0011\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005M!\u0012\u0001B7fi\u0006T\u0011!F\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a55\tA#\u0003\u0002\u001c)\t1\u0011I\\=SK\u001a\f\u0011\u0002\u001d:pm&$WM]:\u0011\u0007y1\u0013F\u0004\u0002 I9\u0011\u0001eI\u0007\u0002C)\u0011!EF\u0001\u0007yI|w\u000e\u001e \n\u0003UI!!\n\u000b\u0002\u000fA\f7m[1hK&\u0011q\u0005\u000b\u0002\u0005\u0019&\u001cHO\u0003\u0002&)A\u0011!fK\u0007\u0002\u001d%\u0011AF\u0004\u0002\u001a'\u0016l\u0017M\u001c;jG\u0012\u0014g)Z1ukJ,\u0007K]8wS\u0012,'/\u0001\u0007ck&dG\rV1sO\u0016$8\u000f\u0005\u0002+_%\u0011\u0001G\u0004\u0002\r\u0005VLG\u000e\u001a+be\u001e,Go]\u0001\no>\u00148n\u001d9bG\u0016\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\n\u0002\u0005%|\u0017BA\u001c5\u00051\t%m]8mkR,\u0007+\u0019;i\u0003\u0019a\u0014N\\5u}Q!!h\u000f\u001f>!\tQ\u0003\u0001C\u0003\u001d\t\u0001\u0007Q\u0004C\u0003.\t\u0001\u0007a\u0006C\u00032\t\u0001\u0007!'A\u0007p]R\u000b'oZ3u%>|Go\u001d\u000b\u0002\u0001B\u0011\u0011$Q\u0005\u0003\u0005R\u0011A!\u00168ji\u0006)!/Z:fi\u0006AqN\u001c#fY\u0016$X\r\u0006\u0002A\r\")qi\u0002a\u0001\u0011\u0006!a-\u001b7f!\tIu*D\u0001K\u0015\t95J\u0003\u0002M\u001b\u0006\u0019a.[8\u000b\u00039\u000bAA[1wC&\u0011\u0001K\u0013\u0002\u0005!\u0006$\b.\u0001\u0006p]>3XM\u001d4m_^$\"\u0001Q*\t\u000bQC\u0001\u0019\u0001%\u0002\tA\fG\u000f[\u0001\u0012_:\u001c\u0005.\u00198hK\u0012K'/Z2u_JLHC\u0001!X\u0011\u0015A\u0016\u00021\u0001I\u0003\r!\u0017N]\u0001\t_:\u001c\u0005.\u00198hKR\u0019\u0001i\u0017/\t\u000bQS\u0001\u0019\u0001\u001a\t\u000buS\u0001\u0019\u00010\u0002\u0019Q,\u0007\u0010\u001e#pGVlWM\u001c;\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005\u0004\u0012AC:f[\u0006tG/[2eE&\u00111\r\u0019\u0002\r)\u0016DH\u000fR8dk6,g\u000e\u001e\u000b\u0004\u0001\u00164\u0007\"\u0002+\f\u0001\u0004\u0011\u0004\"B4\f\u0001\u0004A\u0017\u0001\u00023pGN\u0004\"aX5\n\u0005)\u0004'!\u0004+fqR$unY;nK:$8\u000f\u0006\u0002AY\")q\t\u0004a\u0001\u0011\u0002")
public class SemanticdbIndexer {
    private final List<SemanticdbFeatureProvider> providers;
    private final BuildTargets buildTargets;
    private final AbsolutePath workspace;

    public void onTargetRoots() {
        this.buildTargets.allTargetRoots().foreach((Function1 & Serializable)targetRoot -> {
            this.onChangeDirectory(targetRoot.resolve(Directories$.MODULE$.semanticdb()).toNIO());
            return BoxedUnit.UNIT;
        });
    }

    public void reset() {
        this.providers.foreach((Function1 & Serializable)x$1 -> {
            x$1.reset();
            return BoxedUnit.UNIT;
        });
    }

    public void onDelete(Path file) {
        AbsolutePath absolutePath = AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory());
        this.providers.foreach((Function1 & Serializable)x$2 -> {
            x$2.onDelete(absolutePath);
            return BoxedUnit.UNIT;
        });
    }

    public void onOverflow(Path path) {
        if (path == null) {
            this.onTargetRoots();
        } else {
            MetalsEnrichments$.MODULE$.XtensionPathMetals(path).semanticdbRoot().foreach((Function1 & Serializable)x$3 -> {
                this.onChangeDirectory(x$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void onChangeDirectory(Path dir) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                stream.forEach(x$4 -> this.onChange((Path)x$4));
            }
        }
    }

    public void onChange(AbsolutePath path, TextDocument textDocument) {
        TextDocuments docs = new TextDocuments((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TextDocument[]{textDocument})));
        this.onChange(path, docs);
    }

    private void onChange(AbsolutePath path, TextDocuments docs) {
        this.providers.foreach((Function1 & Serializable)x$5 -> {
            x$5.onChange(docs, path);
            return BoxedUnit.UNIT;
        });
    }

    public void onChange(Path file) {
        block7: {
            if (Files.isDirectory(file, new LinkOption[0])) break block7;
            if (MetalsEnrichments$.MODULE$.XtensionPath(file).isSemanticdb()) {
                try {
                    TextDocuments docs = (TextDocuments)TextDocuments$.MODULE$.parseFrom(Files.readAllBytes(file));
                    SemanticdbClasspath$.MODULE$.toScala(this.workspace, AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory())).foreach((Function1 & Serializable)sourceFile -> {
                        this.onChange(sourceFile, docs);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof InvalidProtocolBufferException) {
                        InvalidProtocolBufferException invalidProtocolBufferException = (InvalidProtocolBufferException)throwable2;
                        BoxedUnit boxedUnit = (BoxedUnit)scribe.package$.MODULE$.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(17).append(file).append(" is not yet ready").toString()), LoggableMessage$.MODULE$.throwable2Message((Function0 & Serializable)() -> invalidProtocolBufferException)}), new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(97), MDC$.MODULE$.global());
                    }
                    if (throwable2 instanceof FileSystemException) {
                        FileSystemException fileSystemException = (FileSystemException)throwable2;
                        BoxedUnit boxedUnit = (BoxedUnit)scribe.package$.MODULE$.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(17).append(file).append(" is not yet ready").toString()), LoggableMessage$.MODULE$.throwable2Message((Function0 & Serializable)() -> fileSystemException)}), new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(100), MDC$.MODULE$.global());
                    }
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        BoxedUnit boxedUnit = (BoxedUnit)scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(37).append("unexpected error processing the file ").append(file).toString()), LoggableMessage$.MODULE$.throwable2Message((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(102), MDC$.MODULE$.global());
                    }
                    throw throwable;
                }
            } else {
                scribe.package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(23).append("not a semanticdb file: ").append(file).toString())}), new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(105), MDC$.MODULE$.global());
            }
        }
    }

    public SemanticdbIndexer(List<SemanticdbFeatureProvider> providers, BuildTargets buildTargets, AbsolutePath workspace) {
        this.providers = providers;
        this.buildTargets = buildTargets;
        this.workspace = workspace;
    }
}

