/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.parser.ConfigDocument;
import com.typesafe.config.parser.ConfigDocumentFactory;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.meta.internal.metals.PathMatcher;
import scala.meta.internal.metals.ScalafmtConfig;
import scala.meta.internal.metals.ScalafmtDialect;
import scala.meta.internal.metals.ScalafmtDialect$;
import scala.meta.internal.semver.SemVer;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ScalafmtConfig$
implements Serializable {
    public static final ScalafmtConfig$ MODULE$ = new ScalafmtConfig$();
    private static final ScalafmtConfig empty = new ScalafmtConfig((Option<SemVer.Version>)None$.MODULE$, (Option<ScalafmtDialect>)None$.MODULE$, (List<Tuple2<PathMatcher, ScalafmtDialect>>)package$.MODULE$.List().empty(), (List<PathMatcher>)package$.MODULE$.List().empty(), (List<PathMatcher>)package$.MODULE$.List().empty());

    public ScalafmtConfig empty() {
        return empty;
    }

    public String update(String configText, Option<String> version, Option<ScalafmtDialect> runnerDialect, Map<String, ScalafmtDialect> fileOverride) {
        Function1 & Serializable doNothing = (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
        Function1 combined = (Function1)((IterableOnceOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1)version.fold((Function0 & Serializable)() -> doNothing, (Function1 & Serializable)v -> (Function1 & Serializable)x$3 -> ScalafmtConfig$.withUpdatedVersion$1(x$3, v)), (Function1)runnerDialect.fold((Function0 & Serializable)() -> doNothing, (Function1 & Serializable)v -> (Function1 & Serializable)x$4 -> ScalafmtConfig$.withUpdatedDialect$1(x$4, v)), (Function1 & Serializable)x$5 -> ScalafmtConfig$.withFileOverride$1(x$5, fileOverride)}))).reduceLeft((Function2 & Serializable)(x$6, x$7) -> x$6.andThen(x$7));
        return (String)combined.apply((Object)configText);
    }

    public Option<String> update$default$2() {
        return None$.MODULE$;
    }

    public Option<ScalafmtDialect> update$default$3() {
        return None$.MODULE$;
    }

    public Map<String, ScalafmtDialect> update$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public Try<ScalafmtConfig> parse(AbsolutePath path) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> ConfigFactory.parseFile((File)path.toFile())).flatMap((Function1 & Serializable)config -> MODULE$.parse((Config)config));
    }

    public Try<ScalafmtConfig> parse(String text) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> ConfigFactory.parseString((String)text)).flatMap((Function1 & Serializable)config -> MODULE$.parse((Config)config));
    }

    public Try<ScalafmtConfig> parse(Config config) {
        return ScalafmtConfig$.getVersion$1(config).flatMap((Function1 & Serializable)version -> ScalafmtConfig$.getRunnerDialect$1(config).flatMap((Function1 & Serializable)runnerDialect -> ScalafmtConfig$.getFileOverrides$1(config).flatMap((Function1 & Serializable)overrides -> ScalafmtConfig$.filters$1("includeFilters", config).flatMap((Function1 & Serializable)includeFilters -> ScalafmtConfig$.filters$1("excludeFilters", config).flatMap((Function1 & Serializable)excludeFilters -> ScalafmtConfig$.paths$1("includePaths", config).flatMap((Function1 & Serializable)includePaths -> ScalafmtConfig$.paths$1("excludePaths", config).map((Function1 & Serializable)excludePaths -> {
            List include = (List)includePaths.$plus$plus((IterableOnce)includeFilters);
            List exclude = (List)excludeFilters.$plus$plus((IterableOnce)excludePaths);
            return new ScalafmtConfig((Option<SemVer.Version>)version, (Option<ScalafmtDialect>)runnerDialect, (List<Tuple2<PathMatcher, ScalafmtDialect>>)overrides, (List<PathMatcher>)include, (List<PathMatcher>)exclude);
        })))))));
    }

    public ScalafmtConfig apply(Option<SemVer.Version> version, Option<ScalafmtDialect> runnerDialect, List<Tuple2<PathMatcher, ScalafmtDialect>> fileOverrides, List<PathMatcher> includeFilters, List<PathMatcher> excludeFilters) {
        return new ScalafmtConfig(version, runnerDialect, fileOverrides, includeFilters, excludeFilters);
    }

    public Option<Tuple5<Option<SemVer.Version>, Option<ScalafmtDialect>, List<Tuple2<PathMatcher, ScalafmtDialect>>, List<PathMatcher>, List<PathMatcher>>> unapply(ScalafmtConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5(x$0.version(), x$0.runnerDialect(), x$0.fileOverrides(), x$0.includeFilters(), x$0.excludeFilters()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ScalafmtConfig$.class);
    }

    private static final ConfigDocument docFrom$1(String s) {
        ConfigParseOptions options = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF);
        return ConfigDocumentFactory.parseString((String)s, (ConfigParseOptions)options);
    }

    private static final String withUpdatedVersion$1(String content, String v) {
        String string;
        ConfigDocument doc = ScalafmtConfig$.docFrom$1(content);
        if (doc.hasPath("version")) {
            string = doc.withValueText("version", new java.lang.StringBuilder(22).append('\"').append(v).append('\"').toString()).render();
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(new java.lang.StringBuilder(12).append("version = \"").append(v).append("\"").toString());
            sb.append(System.lineSeparator());
            sb.append(content);
            string = sb.toString();
        }
        return string;
    }

    private static final String withUpdatedDialect$1(String content, ScalafmtDialect d) {
        String string;
        ConfigDocument doc = ScalafmtConfig$.docFrom$1(content);
        if (doc.hasPath("runner.dialect")) {
            string = doc.withValueText("runner.dialect", d.value()).render();
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(content);
            String sep = System.lineSeparator();
            boolean lastLn = content.endsWith(sep);
            Object object = !lastLn ? sb.append(sep) : BoxedUnit.UNIT;
            sb.append(new java.lang.StringBuilder(17).append("runner.dialect = ").append(d.value()).toString());
            sb.append(sep);
            string = sb.toString();
        }
        return string;
    }

    private static final String withFileOverride$1(String content, Map overrides) {
        String string;
        if (overrides.isEmpty()) {
            string = content;
        } else {
            String sep = System.lineSeparator();
            String values = ((IterableOnceOps)overrides.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                ScalafmtDialect dialect = (ScalafmtDialect)tuple2._2();
                String string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(68).append("|  \"").append(key).append("\" {\n                |     runner.dialect = ").append(dialect.value()).append("\n                |  }").toString()));
                return string;
            })).mkString(new java.lang.StringBuilder(14).append("fileOverride {").append(sep).toString(), sep, new java.lang.StringBuilder(1).append(sep).append("}").append(sep).toString());
            String addSep = content.endsWith(sep) ? "" : sep;
            string = new java.lang.StringBuilder(0).append(content).append(addSep).append(values).toString();
        }
        return string;
    }

    private static final Try getVersion$1(Config conf) {
        return conf.hasPath("version") ? Try$.MODULE$.apply((Function0 & Serializable)() -> SemVer.Version$.MODULE$.fromString(conf.getString("version"))).map((Function1 & Serializable)x$8 -> new Some(x$8)) : new Success((Object)None$.MODULE$);
    }

    private static final Option getRunnerDialectRaw$1(Config conf) {
        Option<ScalafmtDialect> option;
        if (conf.hasPath("runner.dialect")) {
            String v = conf.getString("runner.dialect");
            option = ScalafmtDialect$.MODULE$.fromString(v);
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    private static final Try getRunnerDialect$1(Config conf) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> ScalafmtConfig$.getRunnerDialectRaw$1(conf));
    }

    private static final Try getFileOverrides$1(Config conf) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            List list;
            if (conf.hasPath("fileOverride")) {
                ConfigObject obj = conf.getObject("fileOverride");
                Config asConfig = obj.toConfig();
                Set keys = (Set)JavaConverters$.MODULE$.asScalaSetConverter(obj.keySet()).asScala();
                list = keys.toList().map((Function1 & Serializable)key -> {
                    String quotedKey = new java.lang.StringBuilder(22).append('\"').append((String)key).append('\"').toString();
                    Config innerCfg = asConfig.getConfig(quotedKey);
                    Option dialect = ScalafmtConfig$.getRunnerDialectRaw$1(innerCfg);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)dialect);
                }).collect((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<String, Option<ScalafmtDialect>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            String glob = (String)A1._1();
                            Option option = (Option)A1._2();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                ScalafmtDialect dialect = (ScalafmtDialect)some.value();
                                PathMatcher.Nio matcher = new PathMatcher.Nio(glob);
                                object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)matcher), (Object)dialect);
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<String, Option<ScalafmtDialect>> x1) {
                        Option option;
                        Tuple2<String, Option<ScalafmtDialect>> tuple2 = x1;
                        boolean bl = tuple2 != null && (option = (Option)tuple2._2()) instanceof Some;
                        return bl;
                    }
                });
            } else {
                list = package$.MODULE$.List().empty();
            }
            return list;
        });
    }

    private static final Try readMatchers$1(String path, Function1 f, Config config$1) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> config$1.hasPath(path) ? ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(config$1.getStringList(path)).asScala()).map(f)).toList() : package$.MODULE$.List().empty());
    }

    private static final Try filters$1(String key, Config config$1) {
        return ScalafmtConfig$.readMatchers$1(new java.lang.StringBuilder(8).append("project.").append(key).toString(), (Function1 & Serializable)v -> new PathMatcher.Regex((String)v), config$1);
    }

    private static final Try paths$1(String key, Config config$1) {
        return ScalafmtConfig$.readMatchers$1(new java.lang.StringBuilder(8).append("project.").append(key).toString(), (Function1 & Serializable)v -> new PathMatcher.Nio((String)v), config$1);
    }

    private ScalafmtConfig$() {
    }
}

