/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import coursierapi.Dependency;
import coursierapi.Fetch;
import coursierapi.MavenRepository;
import coursierapi.Repository;
import coursierapi.ResolutionParams;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ScalaVersions$;
import scala.meta.io.Classpath;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class Embedded$ {
    public static final Embedded$ MODULE$ = new Embedded$();
    private static List<Repository> repositories;
    private static volatile boolean bitmap$0;

    private List<Repository> repositories$lzycompute() {
        Embedded$ embedded$ = this;
        synchronized (embedded$) {
            if (!bitmap$0) {
                repositories = (List)MetalsEnrichments$.MODULE$.ListHasAsScala(Repository.defaults()).asScala().toList().$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Repository[]{Repository.central(), Repository.ivy2Local(), MavenRepository.of((String)"https://oss.sonatype.org/content/repositories/public/"), MavenRepository.of((String)"https://oss.sonatype.org/content/repositories/snapshots/")})));
                bitmap$0 = true;
            }
        }
        return repositories;
    }

    public List<Repository> repositories() {
        return !bitmap$0 ? this.repositories$lzycompute() : repositories;
    }

    public Fetch fetchSettings(Dependency dep, Option<String> scalaVersion2, Option<ResolutionParams> resolution) {
        ResolutionParams resolutionParams = (ResolutionParams)resolution.getOrElse((Function0 & Serializable)() -> ResolutionParams.create());
        scalaVersion2.foreach((Function1 & Serializable)scalaVersion -> !ScalaVersions$.MODULE$.isScala3Version((String)scalaVersion) ? resolutionParams.forceVersions(MetalsEnrichments$.MODULE$.MapHasAsJava(((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Dependency[]{Dependency.of((String)"org.scala-lang", (String)"scala-library", (String)scalaVersion), Dependency.of((String)"org.scala-lang", (String)"scala-compiler", (String)scalaVersion), Dependency.of((String)"org.scala-lang", (String)"scala-reflect", (String)scalaVersion)}))).map((Function1 & Serializable)d -> new Tuple2((Object)d.getModule(), (Object)d.getVersion())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava()) : BoxedUnit.UNIT);
        return Fetch.create().addRepositories((Repository[])this.repositories().toArray(ClassTag$.MODULE$.apply(Repository.class))).withDependencies(new Dependency[]{dep}).withResolutionParams(resolutionParams).withMainArtifacts();
    }

    public Option<ResolutionParams> fetchSettings$default$3() {
        return None$.MODULE$;
    }

    private Dependency scalaDependency(String scalaVersion) {
        return Dependency.of((String)"org.scala-lang", (String)"scala-library", (String)scalaVersion);
    }

    private Dependency scala3Dependency(String scalaVersion) {
        String binaryVersion = ScalaVersions$.MODULE$.scalaBinaryVersionFromFullVersion(scalaVersion);
        return binaryVersion.startsWith("3") ? Dependency.of((String)"org.scala-lang", (String)new StringBuilder(15).append("scala3-library_").append(binaryVersion).toString(), (String)scalaVersion) : Dependency.of((String)"ch.epfl.lamp", (String)new StringBuilder(14).append("dotty-library_").append(binaryVersion).toString(), (String)scalaVersion);
    }

    private Dependency mtagsDependency(String scalaVersion) {
        return Dependency.of((String)"org.scalameta", (String)new StringBuilder(6).append("mtags_").append(scalaVersion).toString(), (String)BuildInfo$.MODULE$.metalsVersion());
    }

    private Dependency mdocDependency(String scalaBinaryVersion) {
        String string = scalaBinaryVersion;
        String string2 = "2.11";
        return Dependency.of((String)"org.scalameta", (String)new StringBuilder(5).append("mdoc_").append(scalaBinaryVersion).toString(), (String)(!(string != null ? !string.equals(string2) : string2 != null) ? "2.2.24" : BuildInfo$.MODULE$.mdocVersion()));
    }

    private Dependency semanticdbScalacDependency(String scalaVersion) {
        return Dependency.of((String)"org.scalameta", (String)new StringBuilder(18).append("semanticdb-scalac_").append(scalaVersion).toString(), (String)BuildInfo$.MODULE$.scalametaVersion());
    }

    private List<Path> downloadDependency(Dependency dep, Option<String> scalaVersion, Seq<String> classfiers, Option<ResolutionParams> resolution) {
        return MetalsEnrichments$.MODULE$.ListHasAsScala(this.fetchSettings(dep, scalaVersion, resolution).addClassifiers((String[])classfiers.toArray(ClassTag$.MODULE$.apply(String.class))).fetch()).asScala().toList().map((Function1 & Serializable)x$3 -> x$3.toPath());
    }

    private Seq<String> downloadDependency$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private Option<ResolutionParams> downloadDependency$default$4() {
        return None$.MODULE$;
    }

    public List<Path> downloadScalaSources(String scalaVersion) {
        return this.downloadDependency(this.scalaDependency(scalaVersion), (Option<String>)new Some((Object)scalaVersion), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sources"}))), this.downloadDependency$default$4());
    }

    public List<Path> downloadScala3Sources(String scalaVersion) {
        return this.downloadDependency(this.scala3Dependency(scalaVersion), (Option<String>)new Some((Object)scalaVersion), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sources"}))), this.downloadDependency$default$4());
    }

    public List<Path> downloadSemanticdbScalac(String scalaVersion) {
        return this.downloadDependency(this.semanticdbScalacDependency(scalaVersion), (Option<String>)new Some((Object)scalaVersion), this.downloadDependency$default$3(), this.downloadDependency$default$4());
    }

    public List<Path> downloadSemanticdbJavac() {
        return this.downloadDependency(Dependency.of((String)"com.sourcegraph", (String)"semanticdb-javac", (String)BuildInfo$.MODULE$.javaSemanticdbVersion()), (Option<String>)None$.MODULE$, this.downloadDependency$default$3(), this.downloadDependency$default$4());
    }

    public List<Path> downloadMtags(String scalaVersion) {
        return this.downloadDependency(this.mtagsDependency(scalaVersion), (Option<String>)new Some((Object)scalaVersion), this.downloadDependency$default$3(), this.downloadDependency$default$4());
    }

    public List<Path> downloadMdoc(String scalaBinaryVersion, Option<ResolutionParams> resolutionParams) {
        Dependency x$1 = this.mdocDependency(scalaBinaryVersion);
        None$ x$2 = None$.MODULE$;
        Option<ResolutionParams> x$3 = resolutionParams;
        Seq<String> x$4 = this.downloadDependency$default$3();
        return this.downloadDependency(x$1, (Option<String>)x$2, x$4, x$3);
    }

    public Option<ResolutionParams> downloadMdoc$default$2() {
        return None$.MODULE$;
    }

    public List<Path> rulesClasspath(List<Dependency> dependencies) {
        return dependencies.flatMap((Function1 & Serializable)dep -> MODULE$.downloadDependency((Dependency)dep, (Option<String>)None$.MODULE$, MODULE$.downloadDependency$default$3(), MODULE$.downloadDependency$default$4()).map((Function1 & Serializable)path -> path));
    }

    public URLClassLoader toClassLoader(Classpath classpath, ClassLoader classLoader) {
        URL[] urls = (URL[])classpath.entries().map((Function1 & Serializable)x$4 -> x$4.toNIO().toUri().toURL()).toArray(ClassTag$.MODULE$.apply(URL.class));
        return new URLClassLoader(urls, classLoader);
    }

    public List<Path> scalaLibrary(String scalaVersion) {
        Dependency dependency = ScalaVersions$.MODULE$.isScala3Version(scalaVersion) ? this.scala3Dependency(scalaVersion) : this.scalaDependency(scalaVersion);
        return this.downloadDependency(dependency, (Option<String>)new Some((Object)scalaVersion), this.downloadDependency$default$3(), this.downloadDependency$default$4());
    }

    private Embedded$() {
    }
}

