/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.registry;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.kie.api.definition.process.Process;
import org.kie.kogito.Application;
import org.kie.kogito.event.EventBatch;
import org.kie.kogito.event.impl.ProcessEventBatch;
import org.kie.kogito.event.process.NodeDefinition;
import org.kie.kogito.event.process.ProcessDefinitionDataEvent;
import org.kie.kogito.event.process.ProcessDefinitionEventBody;
import org.kie.kogito.internal.utils.ConversionUtils;
import org.kie.kogito.process.Processes;
import org.kie.kogito.source.files.SourceFile;
import org.kie.kogito.source.files.SourceFilesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionEventRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDefinitionEventRegistry.class);
    private final Application app;
    private final String serviceUrl;
    private final Optional<SourceFilesProvider> sourceFilesProvider;

    public ProcessDefinitionEventRegistry(Application app, String serviceUrl) {
        this(app, serviceUrl, Optional.empty());
    }

    public ProcessDefinitionEventRegistry(Application app, String serviceUrl, Optional<SourceFilesProvider> sourceFilesProvider) {
        this.app = app;
        this.serviceUrl = serviceUrl;
        this.sourceFilesProvider = sourceFilesProvider;
    }

    public void register(Processes processes) {
        ProcessEventBatch eventBatch = new ProcessEventBatch();
        processes.processIds().stream().map(arg_0 -> ((Processes)processes).processById(arg_0)).map(this.mapProcessDefinition(this.app.config().addons().availableAddons(), this.serviceUrl)).forEach(arg_0 -> ProcessDefinitionEventRegistry.lambda$register$0((EventBatch)eventBatch, arg_0));
        LOGGER.debug("Publishing all processes definitions");
        this.app.unitOfWorkManager().eventManager().publish((EventBatch)eventBatch);
    }

    private Function<org.kie.kogito.process.Process<?>, ProcessDefinitionDataEvent> mapProcessDefinition(Set<String> addons, String endpoint) {
        return p -> {
            Process processDefinition;
            Map metadata = Collections.emptyMap();
            if (p instanceof Supplier && (processDefinition = (Process)((Supplier)p).get()) != null) {
                metadata = processDefinition.getMetaData();
            }
            Set annotations = metadata.getOrDefault("annotations", Collections.emptyList()).stream().collect(Collectors.toSet());
            String description = (String)metadata.get("Description");
            ProcessDefinitionEventBody.ProcessDefinitionEventBodyBuilder builder = ProcessDefinitionEventBody.builder().setId(p.id()).setName(p.name()).setVersion(p.version()).setType(p.type()).setAddons(addons).setEndpoint(ProcessDefinitionEventRegistry.getEndpoint(endpoint, p)).setNodes(this.getNodesDefinitions((org.kie.kogito.process.Process<?>)p)).setAnnotations(annotations).setDescription(description).setMetadata(metadata);
            this.sourceFilesProvider.flatMap(provider -> provider.getProcessSourceFile(p.id())).map(this::readSourceFile).ifPresentOrElse(arg_0 -> ((ProcessDefinitionEventBody.ProcessDefinitionEventBodyBuilder)builder).setSource(arg_0), () -> LOGGER.warn("Not source found for process id {}", (Object)p.id()));
            return new ProcessDefinitionDataEvent(builder.build());
        };
    }

    private String readSourceFile(SourceFile s) {
        try {
            return new String(s.readContents());
        }
        catch (IOException e) {
            LOGGER.warn("Error reading content for source file {}", (Object)s, (Object)e);
            return null;
        }
    }

    private static String getEndpoint(String endpoint, org.kie.kogito.process.Process<?> p) {
        String processPath = ConversionUtils.sanitizeToSimpleName((String)p.id());
        return endpoint + "/" + processPath;
    }

    private List<NodeDefinition> getNodesDefinitions(org.kie.kogito.process.Process<?> p) {
        return p.findNodes(n -> true).stream().map(node -> NodeDefinition.builder().setId(String.valueOf(node.getId())).setName(node.getName()).setType(node.getClass().getSimpleName()).setUniqueId(node.getUniqueId()).setMetadata(node.getMetaData()).build()).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$register$0(EventBatch eventBatch, ProcessDefinitionDataEvent process) {
        LOGGER.debug("Registering process definition with id: {}", (Object)process.getId());
        eventBatch.append((Object)process);
    }
}

