/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.core.rules.incubation.quarkus.support;

import java.lang.reflect.Field;
import java.util.UUID;
import org.drools.ruleunits.api.DataHandle;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.api.DataStream;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnits;
import org.drools.ruleunits.impl.datasources.ListDataStore;
import org.drools.ruleunits.impl.factory.DataHandleImpl;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.rules.RuleUnitId;
import org.kie.kogito.incubation.rules.RuleUnitInstanceId;
import org.kie.kogito.incubation.rules.data.DataId;
import org.kie.kogito.incubation.rules.data.DataSourceId;
import org.kie.kogito.incubation.rules.services.DataSourceService;

class DataSourceServiceImpl
implements DataSourceService {
    private final RuleUnits ruleUnits;

    public DataSourceServiceImpl(RuleUnits ruleUnits) {
        this.ruleUnits = ruleUnits;
    }

    public DataContext get(DataId id) {
        DataSource<DataContext> dataSource = this.getDataSource(id);
        if (dataSource instanceof DataStore) {
            ListDataStore ds = (ListDataStore)dataSource;
            DataHandle handle = ds.findHandle(Long.parseLong(id.dataId()));
            return (DataContext)handle.getObject();
        }
        throw new UnsupportedOperationException("Unsupported operation for the given data source type (not a data store)");
    }

    public DataId add(LocalId dataSourceId, DataContext ctx) {
        if (dataSourceId instanceof DataSourceId) {
            DataSourceId dsId = (DataSourceId)dataSourceId;
            DataSource<DataContext> dataSource = this.getDataSource(dsId);
            if (dataSource instanceof DataStore) {
                ListDataStore ds = (ListDataStore)dataSource;
                DataHandleImpl hdl = (DataHandleImpl)ds.add((Object)ctx);
                long handleId = hdl.getId();
                return dsId.data().get(String.valueOf(handleId));
            }
            if (dataSource instanceof DataStream) {
                DataStream ds = (DataStream)dataSource;
                ds.append((Object)ctx);
                return dsId.data().get(UUID.randomUUID().toString());
            }
        }
        throw new IllegalArgumentException("Invalid type " + dataSourceId);
    }

    public void update(DataId dataId, DataContext ctx) {
        DataSource<DataContext> dataSource = this.getDataSource(dataId);
        if (dataSource instanceof DataStore) {
            ListDataStore ds = (ListDataStore)dataSource;
            DataHandle handle = ds.findHandle(Long.parseLong(dataId.dataId()));
            ds.update(handle, (Object)ctx);
        }
        throw new UnsupportedOperationException("Unsupported operation for the given data source type (not a data store)");
    }

    public void remove(DataId dataId) {
        DataSource<DataContext> dataSource = this.getDataSource(dataId);
        if (dataSource instanceof DataStore) {
            ListDataStore ds = (ListDataStore)dataSource;
            DataHandle handle = ds.findHandle(Long.parseLong(dataId.dataId()));
            ds.remove(handle);
        }
        throw new UnsupportedOperationException("Unsupported operation for the given data source type (not a data store)");
    }

    private DataSource<DataContext> getDataSource(DataSourceId dataSourceId) {
        try {
            RuleUnitInstanceId instanceId = dataSourceId.ruleUnitInstanceId();
            RuleUnitId ruleUnitId = instanceId.ruleUnitId();
            Class<RuleUnitData> ruleUnitDataClass = this.toClass(ruleUnitId);
            RuleUnitInstance registeredInstance = this.ruleUnits.getRegisteredInstance(instanceId.ruleUnitInstanceId());
            RuleUnitData data = registeredInstance.ruleUnitData();
            String expectedFieldName = dataSourceId.dataSourceId();
            Field declaredField = ruleUnitDataClass.getDeclaredField(expectedFieldName);
            declaredField.setAccessible(true);
            return (DataSource)declaredField.get(data);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private DataSource<DataContext> getDataSource(DataId dataId) {
        DataSourceId dataSourceId = dataId.dataSourceId();
        return this.getDataSource(dataSourceId);
    }

    private Class<RuleUnitData> toClass(RuleUnitId ruleUnitId) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(ruleUnitId.ruleUnitId());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

