/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.kie.kogito.pmml.PMMLKogito;
import org.kie.kogito.pmml.PmmlPredictionModel;
import org.kie.kogito.prediction.PredictionModel;
import org.kie.kogito.prediction.PredictionModelNotFoundException;
import org.kie.kogito.prediction.PredictionModels;
import org.kie.pmml.api.runtime.PMMLRuntime;

public abstract class AbstractPredictionModels
implements PredictionModels {
    private static final AtomicReference<Function<String, PMMLRuntime>> functionReference = new AtomicReference();
    public static final Function<String, PMMLRuntime> pmmlRuntimeRetrieverFunction = s -> functionReference.get().apply((String)s);

    protected static void init(String ... pmmlFiles) {
        Map<String, PMMLRuntime> pmmlRuntimes = PMMLKogito.createPMMLRuntimes(pmmlFiles);
        Function<String, PMMLRuntime> function = s -> pmmlRuntimes.keySet().stream().filter(pmmlRuntimes::containsKey).map(pmmlRuntimes::get).findFirst().orElseThrow(() -> new PredictionModelNotFoundException("Failed to find PMMLRuntime for model " + s));
        functionReference.set(function);
    }

    @Override
    public PredictionModel getPredictionModel(String fileName, String modelName) {
        return new PmmlPredictionModel(this.getPMMLRuntime(fileName), fileName, modelName);
    }

    private PMMLRuntime getPMMLRuntime(String fileName) {
        return pmmlRuntimeRetrieverFunction.apply(fileName);
    }
}

