/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.process;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ProcessInstanceStateEventBody {
    public static final int EVENT_TYPE_STARTED = 1;
    public static final int EVENT_TYPE_ENDED = 2;
    private Date eventDate;
    private String eventUser;
    private Integer eventType;
    private String processId;
    private String processVersion;
    private String processType;
    private String processInstanceId;
    private String businessKey;
    private String processName;
    private String parentInstanceId;
    private String rootProcessId;
    private String rootProcessInstanceId;
    private Integer state;
    private Set<String> roles;
    public Date slaDueDate;

    public Date getEventDate() {
        return this.eventDate;
    }

    public String getEventUser() {
        return this.eventUser;
    }

    public Integer getEventType() {
        return this.eventType;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessVersion() {
        return this.processVersion;
    }

    public String getProcessType() {
        return this.processType;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getParentInstanceId() {
        return this.parentInstanceId;
    }

    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public String getRootProcessId() {
        return this.rootProcessId;
    }

    public Integer getState() {
        return this.state;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Date getSlaDueDate() {
        return this.slaDueDate;
    }

    public Builder update() {
        return new Builder(this);
    }

    public Map<String, Object> metaData() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("kogito.processinstance.id", this.processInstanceId);
        metadata.put("kogito.process.version", this.processVersion);
        metadata.put("kogito.processinstance.parentInstanceId", this.parentInstanceId);
        metadata.put("kogito.processinstance.rootInstanceId", this.rootProcessInstanceId);
        metadata.put("kogito.process.id", this.processId);
        metadata.put("kogito.process.type", this.processType);
        metadata.put("kogito.processinstance.rootProcessId", this.rootProcessId);
        metadata.put("kogito.processinstance.state", String.valueOf(this.state));
        return metadata;
    }

    public String toString() {
        return "ProcessInstanceStateEventBody [eventDate=" + this.eventDate + ", eventUser=" + this.eventUser + ", eventType=" + this.eventType + ", processId=" + this.processId + ", processVersion=" + this.processVersion + ", processType=" + this.processType + ", processInstanceId=" + this.processInstanceId + ", businessKey=" + this.businessKey + ", processName=" + this.processName + ", parentInstanceId=" + this.parentInstanceId + ", rootProcessId=" + this.rootProcessId + ", rootProcessInstanceId=" + this.rootProcessInstanceId + ", state=" + this.state + ", roles=" + this.roles + "]";
    }

    public int hashCode() {
        return Objects.hash(this.processInstanceId);
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceStateEventBody other = (ProcessInstanceStateEventBody)obj;
        return Objects.equals(this.processInstanceId, other.processInstanceId);
    }

    public static Builder create() {
        return new Builder(new ProcessInstanceStateEventBody());
    }

    public static class Builder {
        private ProcessInstanceStateEventBody instance;

        public Builder(ProcessInstanceStateEventBody instance) {
            this.instance = instance;
        }

        public Builder eventDate(Date eventDate) {
            this.instance.eventDate = eventDate;
            return this;
        }

        public Builder eventUser(String userId) {
            this.instance.eventUser = userId;
            return this;
        }

        public Builder eventType(Integer eventType) {
            this.instance.eventType = eventType;
            return this;
        }

        public Builder processId(String processId) {
            this.instance.processId = processId;
            return this;
        }

        public Builder processVersion(String processVersion) {
            this.instance.processVersion = processVersion;
            return this;
        }

        public Builder processType(String processType) {
            this.instance.processType = processType;
            return this;
        }

        public Builder processInstanceId(String processInstanceId) {
            this.instance.processInstanceId = processInstanceId;
            return this;
        }

        public Builder businessKey(String businessKey) {
            this.instance.businessKey = businessKey;
            return this;
        }

        public Builder processName(String processName) {
            this.instance.processName = processName;
            return this;
        }

        public Builder parentInstanceId(String parentInstanceId) {
            this.instance.parentInstanceId = parentInstanceId;
            return this;
        }

        public Builder rootProcessId(String rootProcessId) {
            this.instance.rootProcessId = rootProcessId;
            return this;
        }

        public Builder rootProcessInstanceId(String rootProcessInstanceId) {
            this.instance.rootProcessInstanceId = rootProcessInstanceId;
            return this;
        }

        public Builder state(Integer state) {
            this.instance.state = state;
            return this;
        }

        public Builder roles(String ... roles) {
            this.instance.roles = Set.of(roles);
            return this;
        }

        public Builder slaDueDate(Date slaDueDate) {
            this.instance.slaDueDate = slaDueDate;
            return this;
        }

        public ProcessInstanceStateEventBody build() {
            return this.instance;
        }
    }
}

